<?php

namespace App\Http\Controllers\Shop;

use App\Models\User;
use App\Models\Reseller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Gloudemans\Shoppingcart\Facades\Cart;

class CheckOutController extends Controller
{
    public function index($username){
        $delivery_charges = DB::table('delivery_charges')->select('id','name','delivery_charge')->get();
        $resellers = Reseller::where('username', $username)->first();
        $pages = DB::table('pages')->where('reseller_id', $resellers->id)->get();
        $data = [
            'delivery_charges' => $delivery_charges,
            'resellers'        => $resellers,
            'pages'            => $pages,
        ];
        $cart_count = Cart::count();
        $name = 'Cart';
        if($cart_count > 0){
            return view('shop.pages.check_out', $data);
        }else{
            return view('shop.pages.cart_blank',compact('name','resellers','pages'));
        }
    }

}