<?php

namespace App\Http\Controllers\Shop;

use App\User;
use Exception;
use Throwable;
use Carbon\Carbon;
use App\Models\City;
use App\Models\Page;
use App\Models\Team;
use App\Models\Brand;
use App\Models\Order;
use App\Models\Banner;
use App\Models\Coupon;
use App\Models\Slider;
use App\Models\Product;
use App\Models\SubCity;
use App\Models\Campaign;
use App\Models\Category;
use App\Models\Reseller;
use App\Models\FlashDeal;
use App\Models\OrderItem;
use App\Models\SubCategory;
use App\Models\ProductImage;
use App\Services\SmsService;
use Illuminate\Http\Request;
use App\Models\FooterSetting;
use App\Models\ProductReview;
use App\Models\CampaignSlider;
use App\Models\GeneralSetting;
use App\Models\ProductVariant;
use App\Models\ResellerSlider;
use App\Models\SubSubCategory;
use App\Models\AboutAndContact;
use App\Models\CampaignProduct;
use App\Models\Category_slider;
use App\Models\OtpVerification;
use App\Models\ResellerCategory;
use App\Models\BuyOneGetOneOffer;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\ResellerProductPrice;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use App\Models\OrderShipmentAndReturnPolicy;

class HomeController extends Controller
{


    public function index($username)
    {
        $resellers = Reseller::where('username', $username)->first();
        session::put('reseller_id', $resellers->id); 
        // $resellers = Reseller::where('id', session()->get('reseller')['id'])->select('logo', 'address', 'username','meta_title', 'meta_description', 'meta_key', 'meta_content')->first();
        //------------frontend slider------------------
        $sliders = DB::table('reseller_sliders')->where('reseller_id',$resellers->id)->select('id', 'image', 'status', 'url', 'reseller_id')
            ->where('status', 1)
            ->inRandomOrder()
            ->latest()
            ->limit(5)->get();
        //----------top section categories--------------
        $top_section_categories = Category::withCount('product')
            ->where('is_selected', 1)
            ->where('status', 1)
            ->orderBy('position', 'asc')
            ->inRandomOrder()
            ->latest()
            ->limit(10)
            ->get();


        //----------top section brands--------------
        $brands = Brand::withCount('product')
                                        ->where('status', 1)
                                        ->orderBy('position', 'asc')
                                        ->inRandomOrder()
                                        ->latest()
                                        ->limit(10)
                                        ->get();

        //------------------- brands -------------------
        $categories = Category::with(['subCategory:id,name,slug,status,category_id', 'subSubCategory:id,name,slug,status,category_id,subcategory_id'])
            ->select('id', 'name', 'slug', 'status')
            ->where('status', 1)
            ->orderBy('position', 'ASC')
            ->limit(8)->get();
        //-------------------- top selling product ---------------------
        $orders_id = Order::where('reseller_id', $resellers->id)->orderBy('id', 'desc')->take(10)->pluck('id');
        $order_items_product_id = OrderItem::whereIn('order_id', $orders_id)->pluck('product_id');
        $top_selling_products = Product::WhereIn('id', $order_items_product_id)
                                            ->select('id', 'name', 'price', 'sale_price', 'reselling_price', 'slug', 'discount', 'thumbnail_img')
                                            ->where('status', 1)
                                            ->get();


        $new_arrival_products = Product::where('status', 1)->select('id', 'name', 'price', 'sale_price', 'slug', 'discount', 'reselling_price', 'thumbnail_img')
                                                            ->orderBy('id', 'desc')
                                                            ->take(10)
                                                            ->get();

        $footer_settings    = DB::table('footer_settings')->first();
        $pages = DB::table('pages')->where('reseller_id', $resellers->id)->get();

        $data = [
            'sliders'                           => $sliders,
            'top_section_categories'            => $top_section_categories,
            'categories'                        => $categories,
            'top_selling_products'              => $top_selling_products,
            'new_arrival_products'              => $new_arrival_products,
            'footer_settings'                   => $footer_settings,
            'pages'                             => $pages,
            'resellers'                         => $resellers,
            'brands'                            => $brands,
        ];

        return view('shop.index', $data);
    }



    public static function getProducts($category_column_name,$category_id,$items){

        return Product::select('id','name','product_code','price','sale_price','reselling_price','slug', 'discount', 'thumbnail_img','created_at')
                        ->where('reselling_price', '>', 0)
                        ->where($category_column_name,$category_id)
                        ->where('status',1)->where('show_homepage',1)
                        ->orderBy('product_position','asc')->take($items)->get();

        }


    //-----------------loadMoreCategoryProduct----------------
    public function loadMoreCategoryProduct(Request $request){
        $resellers = DB::table('resellers')->where('id', session()->get('reseller')['id'])->first();
        $page = $request->page;
        $limit = $request->limit; 
        $start = ($page - 1) * $limit;
        //---------------category wise product---------
        $categories = Category::skip($start)->orderBy('position', 'asc')->where('status', 1)->select('id','name','slug')->with(['subCategory:id,category_id,name,slug'])->paginate($limit);
        foreach($categories as $category) {
            $category->{'products'} = $this::getProducts('category_id',$category->id,12);
        }

        $data = "";
        foreach($categories as $category) { 
            $data .= view('shop.components.load_more_category_product', compact('category','resellers'))->render();
        }
        

        return response()->json([
            'status' => true,
            'data' => $data,
            'category_length' => $categories->count(),
            'message' => 'load Data with category product',
        ]);
    }


    public function resellerInfo(Request $request)
    {
        $reseller = Reseller::where('username', $request->username)->first();
        session::put('reseller_id', $reseller->id);
        return response()->json([
            'success' => true,
            'reseller' => $reseller,
        ]);
    }


    public function  orderTracking(Request $request)
    {

        $data = $request->validate([
            'invoice_no' => 'required',
        ]);

        $general_setting = GeneralSetting::select('title', 'invoice_address_details')->latest()->first();
        $order = Order::with(['customer:id,name,address,phone', 'createAdmin:id,name', 'approvedBy:id,name', 'courier', 'orderItem.product:id,name,thumbnail_img,product_code'])->where('invoice_no', $request->invoice_no)->first();
        if (!empty($order)) {
            $order_status = '';
            switch ($order->status) {
                case 1:
                    $order_status .= 'now your order is processing ';
                    break;
                case 2:
                    $order_status .= 'now your order is pending ';
                    break;

                case 3:
                    $order_status .= ' your order is confirmed ';
                    break;

                case 4:
                    $order_status .= ' your parcel handover to ' . $order->courier->name . ' courier and parcel memo number is ' . $order->memo_no;
                    break;

                case 5:
                    $order_status .= ' your order is delivered ';
                    break;

                case 6:
                    $order_status .= ' your order is canceled ';
                    break;

                case 7:
                    $order_status .= ' this order was returned ';
                    break;

                default:
                    $order_status .= ' unknown order ';
                    break;
            }
            return response()->json([
                'success' => true,
                'message' => $order_status,
                'order' => $order,
                'general_setting' => $general_setting,
            ]);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'No order found. kindly check your order invoice number'
            ]);
        }
    }


    public function get_team_members()
    {
        $team = Team::where('status', 1)
            ->orderBy('position', 'ASC')
            ->get();
        return response()->json([
            'status' => 'OK',
            'team' => $team,
        ]);
    }




    public function productIdWise(Request $request, $id)
    {
        $product = Product::where('status', 1)->where('id', $id)
            ->with(['productImage', 'productAttribute.attribute', 'productVariant.variant', 'resellerProductPrice'])
            ->first();
        return response()->json([
            'product' => $product,
        ]);
    }


    public function landingCategoryWiseProducts(Request $request)
    {
        $reseller = Reseller::where('username', $request->username)->first();
        session::put('reseller_id', $reseller->id);
        $categories = Category::orderBy('position', 'asc')->where('status', 1)->with(['subCategory:id,category_id,name,slug'])->get()->each(function ($category) {
            $reseller_category = ResellerCategory::where('category_id', $category->id)->where('reseller_id', session::get('reseller_id'))->first();
            if ($reseller_category) {
                $category->{'status'} =  $reseller_category->status;
                $category->{'products'} = self::getProducts('category_id', $category->id, 12, session::get('reseller_id'));
            } else {
                $category->{'status'} =  $category->status;
                $category->{'products'} = self::getProducts('category_id', $category->id, 12, session::get('reseller_id'));
            }
        });
        // $reseller = Reseller::where('username', $request->username)->first();
        // foreach($categories as $category) {
        //     $category->{'products'} = self::getProducts('category_id',$category->id,12,$reseller->id);
        // }

        return response()->json([
            'success' => true,
            'categories' => $categories
        ]);
    }




    // public static function  getProducts($category_column_name, $category_id, $items, $reseller_id)
    // {

    //     session::put('reseller_id', $reseller_id);
    //     return Product::where($category_column_name, $category_id)
    //         ->where('status', 1)->where('show_homepage', 1)
    //         ->select('id', 'name', 'product_code', 'price', 'sale_price', 'reselling_price', 'slug', 'discount', 'thumbnail_img', 'status')
    //         ->orderBy('id', 'desc')->with('productVariant:id,product_id,variant_id')->take($items)->get()->each(function ($product) {
    //             $reseller_price = ResellerProductPrice::where('product_id', $product->id)->where('reseller_id', session::get('reseller_id'))->first();
    //             if ($reseller_price) {
    //                 $product->{'reseller_price'} =  $reseller_price->price;
    //                 $product->{'reseller_sale_price'} =  $reseller_price->sale_price;
    //                 $product->{'status'} =  $reseller_price->status;
    //             } else {
    //                 $product->{'reseller_price'} =  $product->reselling_price;
    //                 $product->{'status'} =  $product->status;
    //             }
    //         });
    // }

    public static function getCategoryWiseProducts($category_column_name, $category_id, $reseller_id)
    {
        session::put('reseller_id', $reseller_id);
        return Product::where('status', 1)->where($category_column_name, $category_id)
            ->where('show_homepage', 1)
            ->select('id', 'name', 'product_code', 'price', 'sale_price', 'slug', 'discount', 'thumbnail_img', 'reselling_price', 'status')
            ->orderBy('id', 'desc')
            ->with('productVariant:id,product_id,variant_id')
            ->inRandomOrder()
            ->take(500)
            ->get()->each(function ($product) {
                $reseller_price = ResellerProductPrice::where('product_id', $product->id)->where('reseller_id', session::get('reseller_id'))->first();
                if ($reseller_price) {
                    $product->{'reseller_price'} =  $reseller_price->price;
                    $product->{'reseller_sale_price'} =  $reseller_price->sale_price;
                    $product->{'status'} =  $reseller_price->status;
                } else {
                    $product->{'reseller_price'} =  $product->reselling_price;
                    $product->{'status'} =  $product->status;
                }
            });
    }








    public function flashSale()
    {
        $flash_sale_products = Product::where(['status' => 1, 'product_placement' => 1])
            ->orderBy('product_position', 'DESC')
            ->with('productImage')
            ->select('id', 'name', 'price', 'sale_price', 'slug', 'discount')
            ->get();
        return \response()->json($flash_sale_products);
    }



    public function product(Request $request, $username, $slug)
    {
        // return $username;
        $product = Product::with(['category:id,name,slug,status', 'subCategory:id,name,slug', 'subSubCategory:id,name,slug', 'productImage:id,product_id,image', 'productVariant:id,product_id,variant_id', 'productVariant.variant:id,name,status'])
            ->select('id', 'category_id', 'name', 'product_code', 'thumbnail_img', 'slug', 'sale_price', 'reselling_price', 'discount', 'price', 'stock', 'status', 'details', 'meta_title', 'meta_description', 'meta_key', 'created_at')
            ->where('slug', $request->slug)
            ->where('status', 1)
            ->firstOrFail();

        $category_id = $product->category->id ?? null;
        $sub_category_id = $product->subCategory->id ?? null;
        $sub_sub_category_id = $product->subSubCategory->id ?? null;

        $related_products = DB::table('products')->where('id', '!=', $product->id)->select('id', 'category_id', 'sub_category_id', 'sub_sub_category_id', 'name', 'product_code', 'thumbnail_img', 'slug', 'sale_price', 'reselling_price', 'discount', 'price', 'stock', 'status', 'details', 'created_at')
            ->when($sub_sub_category_id, function ($q, $sub_sub_category_id) {
                $q->where('sub_sub_category_id', $sub_sub_category_id);
            })
            ->when($sub_category_id, function ($q, $sub_category_id) {
                $q->where('sub_category_id', $sub_category_id);
            })
            ->when($category_id, function ($q, $category_id) {
                $q->where('category_id', $category_id);
            })
            ->where('status', 1)
            ->latest()
            ->inRandomOrder()
            ->paginate(12);

        //===================review section start===========================
        $product_review = ProductReview::where('product_id', $product->id)->where('status', 1)->get();

        $five_star = $product_review->where('rating_stars', 5)->count();
        $four_star = $product_review->where('rating_stars', 4)->count();
        $three_star = $product_review->where('rating_stars', 3)->count();
        $two_star = $product_review->where('rating_stars', 2)->count();
        $one_star = $product_review->where('rating_stars', 1)->count();

        $rating_stars = [
            'five_star' => $five_star,
            'four_star' => $four_star,
            'three_star' => $three_star,
            'two_star' => $two_star,
            'one_star' => $one_star,
        ];

        $product->{'rating_stars'} = $rating_stars;

        $product_reviews = ProductReview::where('product_id', $product->id)->where('status', 1)->orderBy('id', 'desc')->paginate(6);
        $total_review = DB::table('product_reviews')->where('status', 1)->where('product_id', $product->id)->count();

        $total_ratings = ($five_star * 5) + ($four_star * 4) + ($three_star * 3) + ($two_star * 2) + ($one_star * 1);
        $average_ratings = $total_ratings / 5;
        //===================review section end===========================
        $delivery_charges = DB::table('delivery_charges')->take(2)->get();

        $reseller = Reseller::where('username', $request->username)->first();
        $reseller_price = ResellerProductPrice::where('reseller_id', $reseller->id)->where('product_id', $product->id)->pluck('sale_price')->first();
        session::put('reseller', $reseller); 
        if ($product->is_same_type_product == 1) {
            $same_type_products = DB::table('same_type_products')->join('products', 'same_type_products.same_type_product_id', 'products.id')->where('same_type_products.product_id', $product->id)->select('products.id', 'products.product_code', 'products.thumbnail_img', 'products.slug')->get();
        }

        $resellers = Reseller::where('id', session()->get('reseller')['id'])->select('logo', 'address', 'username','email','phone','facebook_page_iframe')->first();
        $pages = DB::table('pages')->where('reseller_id', $resellers->id)->get();

        
        $data = [
            'product' => $product,
            'related_products' => $related_products,
            'product_reviews'  => $product_reviews,
            'total_review'     => $total_review,
            'average_ratings'  => $average_ratings,
            'delivery_charges' => $delivery_charges,
            'reseller_price'   => $reseller_price,
            'resellers'        => $resellers,
            'pages'            => $pages,

            'same_type_products' => $product->is_same_type_product == 1 ? $same_type_products : [],
        ];




        return view('shop.pages.product.single_product',  $data);
    }


    public function productImage($slug)
    {
        $product = Product::where('status', 1)->where('slug', $slug)->firstOrFail();
        $product_images = ProductImage::where('product_id', $product->id)->select('id', 'image')->orderBy('id', 'asc')->get();

        return response()->json([
            'success' => true,
            'product_images' => $product_images,
        ]);
    }

    public function relatedProducts(Request $request, $slug)
    {
        $reseller = Reseller::where('username', $request->username)->first();
        $product = Product::where('slug', $slug)->firstOrFail();
        $products = Product::where('status', 1)->where('sub_sub_category_id', $product->sub_sub_category_id)->whereNotNull('sub_sub_category_id')->where('id', '!=', $product->id)->where('show_homepage', 1)
            ->select('id', 'name', 'product_code', 'price', 'sale_price', 'reselling_price', 'slug', 'discount', 'thumbnail_img', 'status')
            ->orderBy('id', 'desc')->orderBy('id', 'desc')->with('productVariant:id,product_id,variant_id')->inRandomOrder()
            ->take(50)->get()->each(function ($product) {
                $reseller_price = ResellerProductPrice::where('product_id', $product->id)->where('reseller_id', session::get('reseller_id'))->first();
                if ($reseller_price) {
                    $product->{'reseller_price'} =  $reseller_price->price;
                    $product->{'reseller_sale_price'} =  $reseller_price->sale_price;
                    $product->{'status'} =  $reseller_price->status;
                } else {
                    $product->{'reseller_price'} =  $product->reselling_price;
                    $product->{'status'} =  $product->status;
                }
            });

        if (count($products) > 0) {

            return response()->json([
                'success' => true,
                'products' => $products,
            ]);
        } else {
            $products = Product::where('status', 1)->where('sub_category_id', $product->sub_category_id)->whereNotNull('sub_category_id')->where('id', '!=', $product->id)->where('show_homepage', 1)
                ->select('id', 'name', 'product_code', 'price', 'sale_price', 'reselling_price', 'slug', 'discount', 'thumbnail_img', 'status')
                ->orderBy('id', 'desc')->with('productVariant:id,product_id,variant_id')->inRandomOrder()
                ->take(50)->get()->each(function ($product) {
                    $reseller_price = ResellerProductPrice::where('product_id', $product->id)->where('reseller_id', session::get('reseller_id'))->first();
                    if ($reseller_price) {
                        $product->{'reseller_price'} =  $reseller_price->price;
                        $product->{'reseller_sale_price'} =  $reseller_price->sale_price;
                        $product->{'status'} =  $reseller_price->status;
                    } else {
                        $product->{'reseller_price'} =  $product->reselling_price;
                        $product->{'status'} =  $product->status;
                    }
                });
            if (count($products) > 0) {
                return response()->json([
                    'success' => true,
                    'products' => $products,
                ]);
            } else {
                $products = Product::where('status', 1)->where('category_id', $product->category_id)->whereNotNull('category_id')->where('id', '!=', $product->id)->where('show_homepage', 1)
                    ->select('id', 'name', 'product_code', 'price', 'sale_price', 'reselling_price', 'slug', 'discount', 'thumbnail_img', 'status')
                    ->orderBy('id', 'desc')->with('productVariant:id,product_id,variant_id')->inRandomOrder()
                    ->take(50)->get()->each(function ($product) {
                        $reseller_price = ResellerProductPrice::where('product_id', $product->id)->where('reseller_id', session::get('reseller_id'))->first();
                        if ($reseller_price) {
                            $product->{'reseller_price'} =  $reseller_price->price;
                            $product->{'reseller_sale_price'} =  $reseller_price->sale_price;
                            $product->{'status'} =  $reseller_price->status;
                        } else {
                            $product->{'reseller_price'} =  $product->reselling_price;
                            $product->{'status'} =  $product->status;
                        }
                    });

                return response()->json([
                    'success' => true,
                    'products' => $products,
                ]);
            }
        }
    }






    public function categories()
    {
        $categories = Category::orderBy('position', 'asc')->where(['status' => 1, 'is_selected' => 1])->select('slug', 'name', 'id', 'icon_image', 'status')->with(['subCategory.SubSubCategory'])->take(11)->get()->each(function ($category) {
            $reseller_category = ResellerCategory::where('category_id', $category->id)->where('reseller_id', session()->get('reseller_id'))->first();
            if ($reseller_category) {
                $category->{'status'} =  $reseller_category->status;
            } else {
                $category->{'status'} =  $category->status;
            }
        });
        return response()->json([
            'success' => true,
            'categories' => $categories,
        ]);
    }


    public function category($slug)
    {

        $category = Category::where('slug', $slug)->select('id', 'name', 'slug')->with(['subCategory:id,category_id,name,slug'])->firstOrFail();
        return response()->json([
            'success' => true,
            'category' => $category,
        ]);
    }




    public function categoryWiseProduct(Request $request, $slug)
    {
        try {
            $reseller = Reseller::where('username', $request->username)->first();
            $category = Category::where('slug', $slug)->firstOrFail();
            $sub_categories = SubCategory::where('category_id', $category->id)->select('id', 'name', 'slug')->get();
            $products = self::getCategoryWiseProducts('category_id', $category->id, $reseller->id);
            return response()->json([
                'success' => true,
                'products' => $products,
                'sub_categories' => $sub_categories,
            ]);
        } catch (Exception $e) {
            return response()->json([
                'success' => false,
                'message' => $e->getMessage(),
            ]);
        }
    }





    public function slider()
    {
        $slider = Slider::where('status', 1)->where('position', 1)->select('id', 'url', 'image')->latest()->get();

        $slider_banner = Banner::latest()->first();
        $best_selling_product_id = OrderItem::where('created_at', '>=', Carbon::today()->subDays('7'))
            ->select('product_id', DB::raw('count(*) as total'))->groupBy('product_id')
            ->orderBy('total', 'desc')->take(12)->pluck('product_id');

        $best_seller_products = Product::WhereIn('id', $best_selling_product_id)->select('id', 'name', 'price', 'sale_price', 'slug', 'discount', 'thumbnail_img')->where('status', 1)->with(['productVariant.variant'])->get();

        return response()->json([
            'success' => true,
            'sliders' => $slider,
            'slider_banner' => $slider_banner,
            'best_seller_products' => $best_seller_products,
        ]);
    }



    //function for display category slider
    public function display_category_slider($slug)
    {
        $category = Category::where('slug', $slug)->first();
        $category_sliders = Category_slider::where('status', 1)
            ->where('category_id', $category->id)
            ->orderBy('id', 'DESC')
            ->get();

        return response()->json([
            'status' => 'OK',
            'category_sliders' => $category_sliders,
        ]);
    }

    //function for display sub category slider
    public function display_sub_category_slider(Request $request)
    {
        $sub_category = SubCategory::where('slug', $request->slug)->first();
        $sub_category_sliders = Category_slider::where('status', 1)
            ->where('sub_category_id', $sub_category->id)
            ->orderBy('id', 'DESC')
            ->get();
        return response()->json([
            'status' => 'OK',
            'sub_category_sliders' => $sub_category_sliders,
        ]);
    }

    //function for display sub sub category slider
    public function display_sub_sub_category_slider(Request $request)
    {
        $sub_sub_category = SubSubCategory::where('slug', $request->slug)->first();

        $sub_sub_category_sliders = Category_slider::where('status', 1)
            ->where('sub_sub_category_id', $sub_sub_category->id)
            ->orderBy('id', 'DESC')
            ->get();
        return response()->json([
            'status' => 'OK',
            'sub_sub_category_sliders' => $sub_sub_category_sliders,
        ]);
    }



    public function subSubCategories($slug)
    {
        $sub_c = SubSubCategory::where('slug', $slug)->firstOrFail();
        $sub_sub_categories = SubSubCategory::orderBy('id', 'desc')->where('status', 1)->where('subcategory_id', $sub_c->subcategory_id)->get();

        return response()->json([
            'success' => true,
            'sub_sub_categories' => $sub_sub_categories,
        ]);
    }




    public function subCategoryWiseProduct(Request $request, $slug)
    {
        try {
            $reseller = Reseller::where('username', $request->username)->first();
            $sub_category = SubCategory::where('slug', $slug)->with('category:id,slug,name')->firstOrFail();
            $sub_sub_categories = SubSubCategory::where('subcategory_id', $sub_category->id)->select('id', 'name', 'slug')->get();
            $products = self::getCategoryWiseProducts('sub_category_id', $sub_category->id, $reseller->id);
            return response()->json([
                'success' => true,
                'products' => $products,
                'sub_sub_categories' => $sub_sub_categories,
            ]);
        } catch (Exception $e) {
            return response()->json([
                'success' => false,
                'message' => $e->getMessage(),
            ]);
        }
    }






    public function subSubCategoryWiseProduct(Request $request, $slug)
    {
        try {
            $reseller = Reseller::where('username', $request->username)->first();
            $sub_sub_category = SubSubCategory::where('slug', $slug)->with('subCategory:id,name')->firstOrFail();
            $products = self::getCategoryWiseProducts('sub_sub_category_id', $sub_sub_category->id, $reseller->id);
            return response()->json([
                'success' => true,
                'products' => $products,
            ]);
        } catch (Exception $e) {
            return response()->json([
                'success' => false,
                'message' => $e->getMessage(),
            ]);
        }
    }




    public function SearchProduct($search)
    {

        if (!is_numeric($search)) {
            $products = Product::where('status', 1)->where('name', 'like', '%' . $search . '%')->where('status', 1)->with('resellerProductPrice')->get();
            return \response()->json($products);
        } else {
            $products = Product::where('product_code', $search)->where('status', 1)->with('resellerProductPrice')->get();
            return \response()->json($products);
        }
    }


    public function subSubCategory($slug)
    {
        $sub_sub_category = SubSubCategory::where('slug', $slug)->first();
        $sub_sub_categories = SubSubCategory::orderBy('id', 'DESC')
            ->where('status', 1)
            ->where('subcategory_id', $sub_sub_category->subcategory_id)
            ->get();
        return response()->json([
            'status' => 'SUCCESS',
            'sub_sub_categories' => $sub_sub_categories,
        ]);
    }



    public function get_quick_view_product($id)
    {
        $product = Product::where('status', 1)->where('id', $id)
            ->with(['productAttribute.attribute', 'productVariant.variant'])
            ->first();
        $recommended_products = Product::where('sub_category_id', $product->sub_category_id)
            ->where('id', '!=', $product->id)
            ->where('status', 1)
            ->with(['productAttribute.attribute', 'productVariant.variant'])
            ->take(24)
            ->get();
        return response()->json([
            'status' => 'OK',
            'product' => $product,
            'recommended_products' => $recommended_products,
        ]);
    }



    public function SendOtp(Request $request)
    {
        $validatedData = $request->validate([
            'mobile_no' => 'required|digits:11',
        ]);
        $reseller = Reseller::where('username', $request->reseller_username)->first();
        $code = random_int(1000, 9999);
        $otp = new OtpVerification();
        $otp->mobile_no = $request->mobile_no;
        $otp->code = Hash::make($code);
        $otp->save();
        if ($reseller->sms_status == 1) {
            $reseller->total_sms = $reseller->total_sms + 1;
            $reseller->save();
            (new SmsService())->sendOtpCode($otp->mobile_no, $code, $reseller->company_name);
        }
        return response()->json([
            'success' => true,
            'message' => 'Sent one time pin on your mobile number'
        ]);
    }



    public function verifyCodeOtp(Request $request)
    {
        $data = $request->validate([
            'code' => 'required|digits:4',
            'mobile_no' => 'required|digits:11',
        ]);

        //  return $request->all();
        $otp = OtpVerification::where('mobile_no', $request->mobile_no)->latest()->first();
        $to_time = strtotime(Carbon::now()->format('Y-m-d g:i:s'));
        $from_time = strtotime(Carbon::parse($otp->created_at)->format('Y-m-d g:i:s'));
        $expire_time = round(abs($to_time - $from_time) / 60, 2);

        if (Hash::check($request->code, $otp->code)) {
            if ($expire_time > 5) {
                return \response()->json('Code Time Expired');
            } else {
                $user = User::where('mobile_no', $request->mobile_no)->first();
                if (empty($user)) {
                    $user = new User();
                    $user->mobile_no = $request->mobile_no;
                    $user->password = Hash::make($request->mobile_no);
                    $user->name = null;
                    $user->email = null;
                    $user->image = null;
                    $user->city_id = null;
                    $user->address = null;
                    $user->status = 1;
                    $user->save();
                }
                Auth::loginUsingId($user->id);
                return \response()->json([
                    'success' => true,
                    'message' => 'Your number is verified',
                    'user' => Auth::user(),
                ]);
            }
        } else {
            return response()->json([
                'success' => false,
                'message' => "sorry! code doesn't match",

            ]);
        }
    }




    public function publish_buy_one_get_one_campaign()
    {
        $buy_get = BuyOneGetOneOffer::latest()->first();
        $buy_get_p = Product::where('status', 1)->where('product_code', $buy_get->product_code)
            ->select(['id', 'name', 'slug', 'price', 'sale_price'])
            ->with('productImage')
            ->first();

        return response()->json([
            'status' => 'OK',
            'buy_get' => $buy_get,
            'buy_get_p' => $buy_get_p,
        ]);
    }

    public function flashDeals()
    {
        $flash_deals = FlashDeal::latest()->first();
        $today = Carbon::today()->format('y-m-d');
        //firstly replacing flash deals expired items

        //now finding which products are exists in flash deals
        $flash_deals_products = Product::where(['status' => 1, 'product_placement' => 1])
            ->where('expired_date', '>', $today)
            ->orderBy('expired_date', 'ASC')
            ->select('id', 'name', 'price', 'sale_price', 'slug', 'expired_date')
            ->with('productImage')
            ->take(5)
            ->get();
        $flash_deals_products_id = [];
        foreach ($flash_deals_products as $item) {
            array_push($flash_deals_products_id, $item->id);
        }
        $flash_slider_products = Product::whereNOtIn('id', $flash_deals_products_id)
            ->where(['status' => 1, 'product_placement' => 1])
            ->where('expired_date', '>', $today)
            ->orderBy('product_position', 'DESC')
            ->select('id', 'name', 'price', 'sale_price', 'slug')
            ->with('productImage')
            ->inRandomOrder()
            ->take(15)
            ->get();
        //adding as a object latest expired date of product
        if ($flash_deals_products->count() > 0) {
            $flash_deals->{'expired_time'} = $flash_deals_products[0]->expired_date;
        }
        return response()->json([
            'status' => 'OK',
            'flash_deals' => $flash_deals,
            'flash_deals_products' => $flash_deals_products,
            'flash_slider_products' => $flash_slider_products,
        ]);
    }

    public function customer_review_to_product(Request $request, $id)
    {
        //   return $request->all() ;
        $request->validate([
            'review_text' => 'required ',
            'star_number' => 'required ',
        ]);

        $review = new ProductReview();
        $review->product_id = $id;
        $review->user_id = Auth::user()->id;
        $review->rating_starts = $request->star_number + 1;
        $review->review = $request->review_text;
        if ($request->hasFile('review_img')) {
            $file_path = $request->file('review_img')->store('images/product_review', 'public');
            $review->image = $file_path;
        }
        $review->status = 0;
        if ($review->save()) {
            return response()->json([
                'status' => 'OK',
                'message' => 'your review added successfully',
            ]);
        }
    }



    public function storeProductReview(Request $request, $product_id)
    {

        $data = $request->validate([
            'review' => 'required ',
            'user_name' => 'required ',
            'rating_stars' => 'required ',
        ]);

        try {
            $product = Product::where('status', 1)->findOrFail($product_id);
            if ($product) {
                $data['product_id'] = $product->id;
                if ($request->hasFile('image')) {
                    $file_path = $request->file('image')->store('images/product_review', 'public');
                    $data['image'] = $file_path;
                }
                ProductReview::query()->create($data);
            }

            return response()->json([
                'success' => true,
                'message' => 'your review added successfully, it will publish soon',
            ]);
        } catch (Throwable $th) {
            return response()->json([
                'success' => false,
                'message' => $th->getMessage(),
            ]);
        }
    }





    public function get_all_flash_deals()
    {
        //return "hello";
        $today = Carbon::today()->format('y-m-d');
        $products = Product::where('expired_date', '>', $today)
            ->orderBy('expired_date', 'ASC')
            ->where(['status' => 1, 'product_placement' => 1])
            ->with('productImage')
            ->get();
        $expired_time = $products[0]->expired_date;

        return response()->json([
            'products' => $products,
            'expired_time' => $expired_time,
        ]);
    }

    public function ApplyCoupon(Request $request)
    {
        $coupon = Coupon::where('code', $request->coupon_code)->first();

        $current_date = date('Y-m-d');

        if (empty($coupon)) {
            return response()->json('Please Give A Valid Coupon Code');
        }

        if ($coupon->status != 1) {
            return response()->json('This Coupon Not Active');
        }

        //  return $coupon->start_date;
        if ($coupon->start_date <= $current_date) {
            if ($coupon->expire_date >= $current_date) {
                return response()->json([
                    'success' => 'OK',
                    'coupon' => $coupon,
                    'message' => 'Coupon Was Successfully Applied',
                ]);
            } else {
                return response()->json('This Coupon Already Expired');
            }
        } else {
            return response()->json('This Coupon Start From ' . $coupon->start_date);
        }

        return response()->json('Some Thing Wrong');
    }

    public function campaigns()
    {
        $campaigns = Campaign::where('status', 1)
            ->whereDate('start_date', '<=', Carbon::now()->today())
            ->whereDate('end_date', '>=', Carbon::now()->today())
            ->with('sliders')->get();

        $sliders = CampaignSlider::whereNull('campaign_id')
            ->where('status', 1)
            ->get();


        return response()->json([
            'campaigns' => $campaigns,
            'campaign_slides' => $sliders,
        ]);
    }



    public function campaign($slug)
    {
        $campaign = Campaign::where(['slug' => $slug, 'status' => 1])
            ->whereDate('start_date', '<=', Carbon::now()->today())
            ->whereDate('end_date', '>=', Carbon::now()->today())
            ->with('sliders')
            ->first();
        $products_id = CampaignProduct::where('campaign_id', $campaign->id)->pluck('product_id');
        $products = Product::where('status', 1)->whereIn('id', $products_id)->select('id', 'name', 'price', 'sale_price', 'slug', 'discount', 'thumbnail_img')
            ->with('productAttribute')->get();
        return response()->json([
            'campaign' => $campaign,
            'products' => $products,
        ]);
    }




    public function cityList()
    {

        $cities = City::where('status', 1)->orderBy('name')->get();
        return response()->json([
            'cities' => $cities,
        ]);
    }


    public function subCities($id)
    {

        $sub_cities = SubCity::where('status', 1)->where('city_id', $id)->orderBy('name')->get();
        return response()->json([
            'status' => 1,
            'sub_cities' => $sub_cities,
        ]);
    }




    public function pageDetails(Request $request)
    {

        $page = Page::where('name', $request->name)->first();
        return response()->json([
            'page' => $page,
        ]);
    }


    public function generalSetting()
    {

        $general_setting = GeneralSetting::latest()->first();
        return response()->json([
            'general_setting' => $general_setting,
        ]);
    }

    public function footerSetting()
    {

        $footer_setting = FooterSetting::latest()->first();
        return response()->json([
            'footer_setting' => $footer_setting,
        ]);
    }





    public function get_about_and_contact()
    {
        $setting = AboutAndContact::latest()->take(1)->first();
        if ($setting) {
            return response()->json([
                "status" => "OK",
                "setting" => $setting,
            ]);
        }
    }




    public function get_order_shipment_return()
    {

        $setting = OrderShipmentAndReturnPolicy::latest()->take(1)->first();
        if ($setting) {
            return response()->json([
                "status" => "OK",
                "setting" => $setting,
            ]);
        }
    }



    public function pageInfo($slug)
    {
        $pageDetails = Page::where('slug', $slug)->firstOrFail();
        return response()->json([
            'success' => true,
            'pageDetails' => $pageDetails,
        ]);
    }




    public function brand()
    {
        $brands = Brand::where('status', 1)->orderBy('position', 'asc')->get();
        return response()->json([
            'success' => true,
            'brands' => $brands
        ]);
    }



    public function brandWiseProduct(Request $request, $slug)
    {
        try {
            $reseller = Reseller::where('username', $request->username)->first();
            $brand = Brand::where('slug', $slug)->firstOrFail();
            $products = self::getCategoryWiseProducts('brand_id', $brand->id, $reseller->id);
            return response()->json([
                'success' => true,
                'products' => $products,
            ]);
        } catch (Exception $e) {
            return response()->json([
                'success' => false,
                'message' => $e->getMessage(),
            ]);
        }
    }













    public function resellerSlider(Request $request)
    {
        $reseller = Reseller::where('username', $request->username)->first();
        $sliders = ResellerSlider::where('reseller_id', $reseller->id)->where('status', 1)->orderBy('position', 'asc')->get();
        return response()->json([
            'success' => true,
            'sliders' => $sliders,
        ]);
    }



    public function resellerPage(Request $request)
    {
        $reseller = Reseller::where('username', $request->username)->first();
        $reseller_pages = Page::where('reseller_id', $reseller->id)->get();
        return response()->json([
            'success' => true,
            'reseller_pages' => $reseller_pages,
        ]);
    }



    public function resellerPageDetails($slug)
    {
        $pageDetails = Page::where('slug', $slug)->first();
        return response()->json([
            'success' => true,
            'pageDetails' => $pageDetails
        ]);
    }






    public function topSellingProduct(Request $request)
    {
        $reseller = Reseller::where('username', $request->username)->first();
        $orders_id = Order::where('reseller_id', $reseller->id)->orderBy('id', 'desc')->take(100)->pluck('id');
        $order_items_product_id = OrderItem::whereIn('order_id', $orders_id)->pluck('product_id');

        $best_selling_products = Product::where('status', 1)->WhereIn('id', $order_items_product_id)
            ->select('id', 'name', 'price', 'reselling_price', 'sale_price', 'slug', 'discount', 'thumbnail_img', 'status')
            ->with('resellerProductPrice')
            ->take(500)
            ->get()->each(function ($product) {
                $reseller_price = ResellerProductPrice::where('product_id', $product->id)->where('reseller_id', session()->get('reseller')['id'])->first();
                if ($reseller_price) {
                    $product->{'reseller_price'} =  $reseller_price->price;
                    $product->{'reseller_sale_price'} =  $reseller_price->sale_price;
                    $product->{'status'} =  $reseller_price->status;
                } else {
                    $product->{'reseller_price'} =  $product->reselling_price;
                    $product->{'status'} =  $product->status;
                }
            });



        return response()->json([
            'success' => true,
            'best_selling_products' => $best_selling_products,
        ]);
    }


    public function flashSaleProduct(Request $request)
    {
        $reseller = Reseller::where('username', $request->username)->first();
        session::put('reseller_id', $reseller->id);
        $mytime = Carbon::now();
        $flash_sale_products = Product::orderBy('id', 'DESC')->where('is_flash_sale', 1)->where('status', 1)
            ->where('flash_start_date', '<=', $mytime->toDateTimeString())
            ->where('flash_end_date', '>=', $mytime->toDateTimeString())
            ->select('id', 'name', 'status', 'price', 'reselling_price', 'sale_price', 'slug', 'discount', 'thumbnail_img', 'flash_start_date', 'flash_end_date', 'is_flash_sale')
            ->with('resellerProductPrice')
            ->take(18)
            ->get()->each(function ($product) {
                $reseller_price = ResellerProductPrice::where('product_id', $product->id)->where('reseller_id', session()->get('reseller_id'))->first();
                if ($reseller_price) {
                    $product->{'reseller_price'} =  $reseller_price->price;
                    $product->{'reseller_sale_price'} =  $reseller_price->sale_price;
                    $product->{'status'} =  $reseller_price->status;
                } else {
                    $product->{'reseller_price'} =  $product->reselling_price;
                    $product->{'status'} =  $product->status;
                }
            });



        return response()->json([
            'success' => true,
            'flash_sale_products' => $flash_sale_products,
        ]);
    }



    public function hotSellingProduct(Request $request)
    {
        $reseller = Reseller::where('username', $request->username)->first();
        session::put('reseller_id', $reseller->id);
        $order_items_product_id = OrderItem::where('created_at', '>=', Carbon::today()->subDays('7'))->select('product_id', DB::raw('SUM(quantity) as total_order'))
            ->groupBy('product_id')
            ->orderByDesc('total_order')
            ->take(18)
            ->pluck('product_id');
        $hot_selling_products = Product::where('status', 1)->WhereIn('id', $order_items_product_id)->orderBy('id', 'desc')
            ->select('id', 'name', 'price', 'reselling_price', 'sale_price', 'slug', 'discount', 'thumbnail_img', 'status')
            ->with('resellerProductPrice')
            ->get()->each(function ($product) {
                $reseller_price = ResellerProductPrice::where('product_id', $product->id)->where('reseller_id', session()->get('reseller_id'))->first();
                if ($reseller_price) {
                    $product->{'reseller_price'} =  $reseller_price->price;
                    $product->{'reseller_sale_price'} =  $reseller_price->sale_price;
                    $product->{'status'} =  $reseller_price->status;
                } else {
                    $product->{'reseller_price'} =  $product->reselling_price;
                    $product->{'status'} =  $product->status;
                }
            });

        return response()->json([
            'success' => true,
            'hot_selling_products' => $hot_selling_products,
        ]);
    }
}
