<?php

namespace App\Http\Controllers\Shop;
use App\Models\Benefit;
use App\Models\Product;
use App\Models\Reseller;
use App\Models\Solution;
use App\Models\LandingPage;
use Illuminate\Http\Request;
use App\Models\FooterSetting;
use App\Models\ProductReview;
use App\Models\DeliveryCharge;
use App\Models\GeneralSetting;
use App\Http\Controllers\Controller;
use App\Models\ResellerProductPrice;
use App\Models\LandingPageProductImage;
use Gloudemans\Shoppingcart\Facades\Cart;

class LandingPageController extends Controller
{
    public function index($username, $slug)
    {
        Cart::destroy();
        if(Cart::count() ==  0){
            $page = LandingPage::where('status', 1)->where('page_slug', $slug)->firstOrFail();
            $reseller = Reseller::where('username', $username)->first();
            ResellerProductPrice::where('is_auto_cart',1)->where('reseller_id', $reseller->id)->where('landing_page_id', $page->id)->orderBy('id','desc')->get()->each(function($reseller_product){
                $product = Product::findOrFail($reseller_product->product_id);
                Cart::add([
                    'id' => $product->id,
                    'name' => $product->name,
                    'slug' => $product->slug,
                    'qty' => 1,
                    'price' => $reseller_product->price,
                    'weight' => 0,
                    'tax' => 0,
                    'options' => [
                        'original_price' => $product->sale_price,
                        'image' => $product->thumbnail_img,
                    ],
                ]);
            });
        }
        return view('shop.master');
    }



    public static function getProducts($username, $slug)
    {
        $page = LandingPage::where('status', 1)->where('page_slug', $slug)->firstOrFail();
        $reseller = Reseller::where('username', $username)->first();
        $products = ResellerProductPrice::where('status', 1)->where('landing_page_id', $page->id)->where('reseller_id', $reseller->id)->with('main_product')->orderBy('id', 'desc')->take(10)->get();
        return response()->json([
            'success' => true,
            'products' => $products,
        ]);
    }

    public function landingPage($slug)
    {
        $page = LandingPage::where('status', 1)->where('page_slug', $slug)->firstOrFail();
        return response()->json([
            'success' => true,
            'page' => $page,
        ]);
    }



    public function benefits($slug)
    {
        $landing_page = LandingPage::where('status', 1)->where('page_slug', $slug)->firstOrFail();
        $benefits = Benefit::where('landing_page_id', $landing_page->id)->where('status', 1)->orderBy('position', 'asc')->get();
        return response()->json([
            'success' => true,
            'benefits' => $benefits,
        ]);
    }



    public function solutions($slug)
    {
        $landing_page = LandingPage::where('status', 1)->where('page_slug', $slug)->firstOrFail();
        $solutions = Solution::where('landing_page_id', $landing_page->id)->where('status', 1)->orderBy('id', 'desc')->get();
        return response()->json([
            'success' => true,
            'solutions' => $solutions,
        ]);
    }



    public function reviews($slug)
    {
        $landing_page = LandingPage::where('status', 1)->where('page_slug', $slug)->firstOrFail();
        $reviews = ProductReview::where('landing_page_id', $landing_page->id)->where('status', 1)->orderBy('id', 'desc')->get();
        return response()->json([
            'success' => true,
            'reviews' => $reviews,
        ]);
    }



    public function images($slug)
    {
        $landing_page = LandingPage::where('status', 1)->where('page_slug', $slug)->firstOrFail();
        $images = LandingPageProductImage::where('landing_page_id', $landing_page->id)->where('status', 1)->orderBy('id', 'desc')->get();
        return response()->json([
            'success' => true,
            'images' => $images,
        ]);
    }

    



    public function generalSetting()
    {
        $general_setting = GeneralSetting::latest()->first();
        return response()->json([
            'general_setting' => $general_setting,
        ]);
    }

    public function footerSetting()
    {

        $footer_setting = FooterSetting::latest()->first();
        return response()->json([
            'footer_setting' => $footer_setting,
        ]);
    }







    public function deliveryCharge()
    {
        $deliveryCharge = DeliveryCharge::all();
        return response()->json([
            'success' => true,
            'deliveryCharge' => $deliveryCharge,
        ]);
    }







    public function autoCartProduct()
    {

        // if (Cart::total() == 0) {
        //     $products = Product::where('is_auto_cart', 1)->where('status', 1)->orderBy('id', 'desc')->get()->each(function ($product) {
        //         Cart::add([
        //             'id' => $product->id,
        //             'name' => $product->name,
        //             'slug' => $product->slug,
        //             'qty' => 1,
        //             'price' => $product->sale_price,
        //             'weight' => 0,
        //             'tax' => 0,
        //             'options' => [
        //                 'original_price' => $product->price,
        //                 'image' => $product->thumbnail_img,
        //                 'is_free_delivery' => $product->is_free_delivery,
        //             ],
        //         ]);
        //     });

        //     return response()->json([
        //         'products' => $products,
        //     ]);
        // } else {
        //     return response()->json([
        //         'message' => 'Called',
        //     ]);
        // }
    }
}
