<?php

namespace App\Http\Controllers\Shop;

use App\Models\Reseller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Gloudemans\Shoppingcart\Facades\Cart;

class WishListController extends Controller
{
    public function index($username)
    {
        // session()->flush();
        // return;
        $wishlist_content   = Cart::instance('wishlist')->content();
        $wishlist_total     = Cart::instance('wishlist')->total();
        $wishlist_count     = Cart::instance('wishlist')->count();
        $resellers = Reseller::where('username', $username)->first();
        $pages = DB::table('pages')->where('reseller_id', $resellers->id)->get();
        $data = [
            'wishlist_content'  => $wishlist_content,
            'wishlist_total'    => $wishlist_total,
            'wishlist_count'    => $wishlist_count,
            'pages'             => $pages,
            'resellers'             => $resellers,
        ];
        $cart_count = Cart::instance('wishlist')->count();
        $name = 'Wish List';
        
        if($cart_count > 0){
            return view('shop.pages.wish_list', $data);
        }else{
            return view('shop.pages.cart_blank',compact('name','resellers','pages'));
        }
    }

    public function addToWishlist(Request $request)
    {
        $product = DB::table('products')
                            ->where('id', $request->id)
                            ->select('id','name','slug','reselling_price','thumbnail_img')
                            ->first(); 

        $add = Cart::instance('wishlist')->add([
            'id' => $product->id,
            'name' => $product->name,
            'qty' => $request->quantity ?? 1,
            'price' => $product->reselling_price,
            'weight' => 0,
            'tax' => 0,
            'options' => [
                'image' => $product->thumbnail_img,    
                'slug' => $product->slug,
            ],
        ]);

        return response()->json(
            [
                'status'    => true,
                'message'  => 'Add to Wish-list Successfully Add',
            ],
            200
        );

        
    }
    public function getWishList(){
        $wishlist_content   = Cart::instance('wishlist')->content();
        $wishlist_total     = Cart::instance('wishlist')->total();
        $item_count     = Cart::instance('wishlist')->count();

        return response()->json(
            [
                'wishlist_total'    => $wishlist_total ?? 0,
                'wishlist_content'  => $wishlist_content ?? 0,
                'item_count'        => $item_count ?? 0,
            ],
            200
        );
    }


    public function deleteWishList(Request $request){
        Cart::instance('wishlist')->remove($request->rowId);

        return response()->json([
            'status' => true,
            'message' => 'Delete Successfully',
        ]);
    }
}
