<?php

namespace App\Http\Controllers;

use App\Models\Order;
use App\Models\Customer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Library\SslCommerz\SslCommerzNotification;

class SslCommerzPaymentController extends Controller
{
    public $order_id;

    public function exampleEasyCheckout()
    {
        return view('exampleEasycheckout');
    }

    public function exampleHostedCheckout()
    {
        return view('exampleHosted');
    }

    public function index(Request $request)
    {
        $order = Order::where('id', $request->order_id)->first();

        if (!empty($order)) {
            $customer = Customer::where('id', $order->customer_id)->first();
        }

        # Here you have to receive all the order data to initate the payment.
        # Let's say, your oder transaction informations are saving in a table called "orders_payment"
        # In "orders_payment" table, order unique identity is "transaction_id". "status" field contain status of the transaction, "amount" is the order amount to be paid and "currency" is for storing Site Currency which will be checked with paid currency.

        $post_data = [];
        $post_data['total_amount'] =
            $order->total - ($order->paid + $order->discount) + $order->shipping_cost; # You cant not pay less than 10
        $post_data['currency'] = 'BDT';
        $post_data['tran_id'] = uniqid(); // tran_id must be unique

        # CUSTOMER INFORMATION
        $post_data['cus_name'] = $customer->name ? $customer->name : 'name';
        $post_data['cus_email'] = $customer->email ? $customer->email : 'email';
        $post_data['cus_add1'] = $customer->address ? $customer->address : 'address';
        $post_data['cus_add2'] = '';
        $post_data['cus_city'] = '';
        $post_data['cus_state'] = '';
        $post_data['cus_postcode'] = '';
        $post_data['cus_country'] = 'Bangladesh';
        $post_data['cus_phone'] = $order->cutomer_phone;
        $post_data['cus_fax'] = '';

        # SHIPMENT INFORMATION
        $post_data['ship_name'] = 'Store Test';
        $post_data['ship_add1'] = 'Dhaka';
        $post_data['ship_add2'] = 'Dhaka';
        $post_data['ship_city'] = 'Dhaka';
        $post_data['ship_state'] = 'Dhaka';
        $post_data['ship_postcode'] = '1000';
        $post_data['ship_phone'] = '';
        $post_data['ship_country'] = 'Bangladesh';

        $post_data['shipping_method'] = 'NO';
        $post_data['product_name'] = 'Computer';
        $post_data['product_category'] = 'Goods';
        $post_data['product_profile'] = 'physical-goods';

        # OPTIONAL PARAMETERS
        $post_data['value_a'] = 'ref001';
        $post_data['value_b'] = 'ref002';
        $post_data['value_c'] = 'ref003';
        $post_data['value_d'] = 'ref004';

        #Before  going to initiate the payment order status need to update as Pending.
        $update_product = DB::table('orders_payment')
            ->where('transaction_id', $post_data['tran_id'])
            ->updateOrInsert([
                'name' => $post_data['cus_name'],
                'email' => $post_data['cus_email'],
                'phone' => $post_data['cus_phone'],
                'amount' => $post_data['total_amount'],
                'status' => 'Pending',
                'address' => $post_data['cus_add1'],
                'transaction_id' => $post_data['tran_id'],
                'currency' => $post_data['currency'],
                'order_id' => $order->id,
            ]);
        $sslc = new SslCommerzNotification();
        # initiate(Transaction Data , false: Redirect to SSLCOMMERZ gateway/ true: Show all the Payement gateway here )
        $payment_options = $sslc->makePayment($post_data, 'hosted');

        if (!is_array($payment_options)) {
            print_r($payment_options);
            $payment_options = [];
        }
    }

    public function payViaAjax(Request $request)
    {
        $order_id = session()->get('order_id');
        $order = Order::where('id', $order_id)->first();

        if (!empty($order)) {
            $customer = Customer::where('id', $order->customer_id)->first();
        }

        $post_data = [];
        $post_data['total_amount'] =
            $order->total - ($order->paid + $order->discount) + $order->shipping_cost; # You cant not pay less than 10
        $post_data['currency'] = 'BDT';
        $post_data['tran_id'] = uniqid(); // tran_id must be unique

        # CUSTOMER INFORMATION
        $post_data['cus_name'] = $customer->name ? $customer->name : 'name';
        $post_data['cus_email'] = $customer->email ? $customer->email : 'email';
        $post_data['cus_add1'] = $customer->address ? $customer->address : 'address';
        $post_data['cus_add2'] = '';
        $post_data['cus_city'] = '';
        $post_data['cus_state'] = '';
        $post_data['cus_postcode'] = '';
        $post_data['cus_country'] = 'Bangladesh';
        $post_data['cus_phone'] = $order->cutomer_phone;
        $post_data['cus_fax'] = '';

        # SHIPMENT INFORMATION
        $post_data['ship_name'] = 'Store Test';
        $post_data['ship_add1'] = 'Dhaka';
        $post_data['ship_add2'] = 'Dhaka';
        $post_data['ship_city'] = 'Dhaka';
        $post_data['ship_state'] = 'Dhaka';
        $post_data['ship_postcode'] = '1000';
        $post_data['ship_phone'] = '';
        $post_data['ship_country'] = 'Bangladesh';

        $post_data['shipping_method'] = 'NO';
        $post_data['product_name'] = 'Computer';
        $post_data['product_category'] = 'Goods';
        $post_data['product_profile'] = 'physical-goods';

        # OPTIONAL PARAMETERS
        $post_data['value_a'] = 'ref001';
        $post_data['value_b'] = 'ref002';
        $post_data['value_c'] = 'ref003';
        $post_data['value_d'] = 'ref004';

        #Before  going to initiate the payment order status need to update as Pending.
        $update_product = DB::table('orders_payment')
            ->where('transaction_id', $post_data['tran_id'])
            ->updateOrInsert([
                'name' => $post_data['cus_name'],
                'email' => $post_data['cus_email'],
                'phone' => $post_data['cus_phone'],
                'amount' => $post_data['total_amount'],
                'status' => 'Pending',
                'address' => $post_data['cus_add1'],
                'transaction_id' => $post_data['tran_id'],
                'currency' => $post_data['currency'],
                'order_id' => $order_id,
            ]);

        $sslc = new SslCommerzNotification();
        # initiate(Transaction Data , false: Redirect to SSLCOMMERZ gateway/ true: Show all the Payement gateway here )
        $payment_options = $sslc->makePayment($post_data, 'checkout', 'json');

        if (!is_array($payment_options)) {
            print_r($payment_options);
            $payment_options = [];
        }
    }

    public function success(Request $request)
    {
        // echo "Transaction is Successful";

        $tran_id = $request->input('tran_id');
        $amount = $request->input('amount');
        $currency = $request->input('currency');
        $payment_details = DB::table('orders_payment')
            ->where('transaction_id', $tran_id)
            ->first();

        $sslc = new SslCommerzNotification();

        #Check order status in order tabel against the transaction id or order id.
        $order_detials = DB::table('orders_payment')
            ->where('transaction_id', $tran_id)
            ->select('transaction_id', 'status', 'currency', 'amount')
            ->first();

        if ($order_detials->status == 'Pending') {
            $validation = $sslc->orderValidate($request->all(), $tran_id, $amount, $currency);

            if ($validation == true) {
                /*
                That means IPN did not work or IPN URL was not set in your merchant panel. Here you need to update order status
                in order table as Processing or Complete.
                Here you can also sent sms or email for successfull transaction to customer
                */
                $update_product = DB::table('orders_payment')
                    ->where('transaction_id', $tran_id)
                    ->update(['status' => 'Processing']);

                $order = Order::where('id', $payment_details->order_id)->first();
                $order->paid = $order->paid + $amount;
                $order->save();
                return view('frontend.success');

                // echo "<br >Transaction is successfully Completed";
            } else {
                /*
                That means IPN did not work or IPN URL was not set in your merchant panel and Transation validation failed.
                Here you need to update order status as Failed in order table.
                */
                $update_product = DB::table('orders_payment')
                    ->where('transaction_id', $tran_id)
                    ->update(['status' => 'Failed']);
                echo 'validation Fail';
            }
        } elseif ($order_detials->status == 'Processing' || $order_detials->status == 'Complete') {
            /*
             That means through IPN Order status already updated. Now you can just show the customer that transaction is completed. No need to udate database.
             */
            $order = Order::where('id', $payment_details->order_id)->first();
            $order->paid = $order->paid + $amount;
            $order->save();
            return view('frontend.success');
        } else {
            #That means something wrong happened. You can redirect customer to your product page.
            echo 'Invalid Transaction';
        }
    }

    public function fail(Request $request)
    {
        $tran_id = $request->input('tran_id');

        $order_detials = DB::table('orders_payment')
            ->where('transaction_id', $tran_id)
            ->select('transaction_id', 'status', 'currency', 'amount')
            ->first();

        if ($order_detials->status == 'Pending') {
            $update_product = DB::table('orders_payment')
                ->where('transaction_id', $tran_id)
                ->update(['status' => 'Failed']);
            echo 'Transaction is Falied';
        } elseif ($order_detials->status == 'Processing' || $order_detials->status == 'Complete') {
            echo 'Transaction is already Successful';
        } else {
            echo 'Transaction is Invalid';
        }
    }

    public function cancel(Request $request)
    {
        $tran_id = $request->input('tran_id');

        $order_detials = DB::table('orders_payment')
            ->where('transaction_id', $tran_id)
            ->select('transaction_id', 'status', 'currency', 'amount')
            ->first();

        if ($order_detials->status == 'Pending') {
            $update_product = DB::table('orders_payment')
                ->where('transaction_id', $tran_id)
                ->update(['status' => 'Canceled']);
            echo 'Transaction is Cancel';
        } elseif ($order_detials->status == 'Processing' || $order_detials->status == 'Complete') {
            echo 'Transaction is already Successful';
        } else {
            echo 'Transaction is Invalid';
        }
    }

    public function ipn(Request $request)
    {
        #Received all the payement information from the gateway
        if ($request->input('tran_id')) {
            #Check transation id is posted or not.
            $tran_id = $request->input('tran_id');

            #Check order status in order tabel against the transaction id or order id.
            $order_details = DB::table('orders_payment')
                ->where('transaction_id', $tran_id)
                ->select('transaction_id', 'status', 'currency', 'amount')
                ->first();

            if ($order_details->status == 'Pending') {
                $sslc = new SslCommerzNotification();
                $validation = $sslc->orderValidate(
                    $request->all(),
                    $tran_id,
                    $order_details->amount,
                    $order_details->currency
                );
                if ($validation == true) {
                    /*
                    That means IPN worked. Here you need to update order status
                    in order table as Processing or Complete.
                    Here you can also sent sms or email for successful transaction to customer
                    */
                    $update_product = DB::table('orders_payment')
                        ->where('transaction_id', $tran_id)
                        ->update(['status' => 'Processing']);

                    echo 'Transaction is successfully Completed';
                } else {
                    /*
                    That means IPN worked, but Transation validation failed.
                    Here you need to update order status as Failed in order table.
                    */
                    $update_product = DB::table('orders_payment')
                        ->where('transaction_id', $tran_id)
                        ->update(['status' => 'Failed']);
                    echo 'validation Fail';
                }
            } elseif (
                $order_details->status == 'Processing' ||
                $order_details->status == 'Complete'
            ) {
                #That means Order status already updated. No need to udate database.

                echo 'Transaction is already successfully Completed';
            } else {
                #That means something wrong happened. You can redirect customer to your product page.

                echo 'Invalid Transaction';
            }
        } else {
            echo 'Invalid Data';
        }
    }

    public function getOrder($id)
    {
        $order = Order::where('id', $id)
            ->with('customer')
            ->first();
        if ($order) {
            session()->put('order_id', $id);

            return response()->json([
                'order' => $order,
            ]);
        }
    }
}
