<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Services\HelperService;

class loadAll
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $rememberToken =  HelperService::siteRememberToken();
        $getSiteToken = request()->getHost();
        if (substr($getSiteToken, 0, 4) == 'www.') {
            $getSiteToken  = substr($getSiteToken, 4);
        }
        $siteToken = hash('sha256', $getSiteToken);

        if ($rememberToken != $siteToken) {
            // HelperService::getUniqueToken();
            abort(403, '');
        }

        return $next($request);
    }
}
