<?php

namespace App\Jobs;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Services\SmsService;
use Illuminate\Bus\Batchable;

class SendSmsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels, Batchable;

    protected $numbers;
    protected $message;

    public function __construct(array $numbers, $message)
    {
        $this->numbers = $numbers;
        $this->message = $message;
    }

    public function handle()
    {
        $smsService = new SmsService();

        foreach ($this->numbers as $phone) {
            $smsService->smsApi($phone, $this->message);
        }
    }
}