<?php

namespace App\Models;
use Carbon\Carbon;

use Illuminate\Database\Eloquent\Model;

class Balance extends Model
{


     public function  today_credit_balance()
     {
     return $this->hasMany("App\Models\Credit","balance_id")->where('date', '>=', Carbon::today()->startOfDay())
               ->where('date', '<=', Carbon::today()->endOfDay())->orderBy('created_at','desc');
     }



     public function  total_credit_balance(){
          return $this->hasMany("App\Models\Credit","balance_id")->orderBy('created_at','desc') ;
     }


     public function  today_debit_balance(){
          return $this->hasMany("App\Models\Debit","balance_id")->where('date', '>=', Carbon::today()->startOfDay())
                    ->where('date', '<=', Carbon::today()->endOfDay())->orderBy('created_at','desc');

     }



     public function  total_debit_balance(){
          return $this->hasMany("App\Models\Debit","balance_id")->orderBy('created_at','desc') ;
     }

     public function order(){
          return $this->hasMany('App\Models\Order','balance_id');
     }

     public function sale(){
          return $this->hasMany('App\Models\Sale','balance_id');
     }


     public function credit(){
          return $this->hasMany('App\Models\Credit','balance_id');
     }

     public function debit(){
          return $this->hasMany('App\Models\Debit','balance_id');
     }





}
