<?php

namespace App\Models;

use DateTimeInterface;
use Illuminate\Database\Eloquent\Model;

class FondTransfer extends Model
{
    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
    public function balance()
    {
        return $this->belongsTo('App\Models\Balance', 'from');
    }

    public function balanceTo()
    {
        return $this->belongsTo('App\Models\Balance', 'to');
    }
}
