<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LandingPage extends Model
{
    
    protected $fillable = ['id', 'page_name', 'page_slug', 'main_banner', 'main_title', 'hotline_title', 'hotline_phone', 'hotline_image', 'video_title', 'video_url', 'video_title_two', 'video_url_two', 'description_title', 'status', 'created_at', 'updated_at'];


    public function product(){
        return $this->hasMany(Product::class, 'landing_page_id');
    }
    public function landingPageReview(){
        return $this->hasMany(LandingPageReview::class, 'landing_page_id');
    }
    public function description(){
        return $this->hasMany(Description::class, 'landing_page_id');
    }
}
