<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OrderItem extends Model
{
    protected $guarded  = ['id'];

    // protected $fillable = [
    //     'order_id',
    //     'product_id',
    //     'price',
    //     'quantity',
    //     'total',
    //     'purchase_price',
    //     'admin_sale_price',
    //     'size',
    //     'color',
    //     'bed_set',
    //     'weight',
    //     'status',
    // ];

    public function product(){
        return $this->belongsTo('App\Models\Product','product_id')->select(['id','merchant_id','name','stock','price','sale_price','discount','product_code','thumbnail_img']);
    }
    public function attribute(){
        return $this->belongsTo('App\Models\Attribute','attribute_id');
    }
    public function variant(){
         return $this->belongsTo('App\Models\Variant','variant_id');
    }

    public function variants()
    {
        return $this->hasMany(OrderItemVariant::class);
    }
    protected $appends = ['variant_name'];

    public function getVariantNameAttribute()
    {
        return optional($this->orderItemVariant)->variant_name;
    }

    public function OrderItemVariant(){
        return $this->hasOne('App\Models\OrderItemVariant','order_item_id');
    }



}
