<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    protected $fillable = ['id', 'name', 'merchant_id', 'category_id', 'sub_category_id', 'sub_sub_category_id', 'is_book', 'author_id', 'publisher_id', 'brand_id', 'product_code', 'thumbnail_img', 'slug', 'is_manual_stock', 'stock', 'sale_price', 'discount', 'price', 'reselling_price', 'show_reseller_panel', 'status', 'product_position', 'product_placement', 'details', 'select_home_page', 'show_homepage', 'expired_date', 'single_checkout', 'is_combo', 'merchant_commission', 'feature_product', 'video_url', 'is_free_delivery', 'affiliate_profit', 'meta_title', 'meta_description', 'meta_key', 'meta_content','is_add_to_pos', 'barcode','is_eatured', 'is_buy_one_get_one', 'is_featured', 'country_id', 'is_daily_offer', 'information', 'created_at', 'updated_at', 'size_chart'];

    public function productImage()
    {
        return $this->hasMany('App\Models\ProductImage', 'product_id');
    }

    public function comboItems()
    {
        return $this->hasMany(ComboProduct::class, 'general_product_id');
    }

    public function bookImage()
    {
        return $this->hasMany('App\Models\BookAttachmentsImg', 'product_id');
    }

    public  function productBarcode()
    {
        return $this->hasOne('App\Models\ProductBarcode', 'product_id');
    }
    public function author()
    {
        return $this->belongsTo('App\Models\Author', 'author_id');
    }
    public function publisher()
    {
        return $this->belongsTo('App\Models\Publisher', 'publisher_id');
    }


    public function productAttribute()
    {
        return $this->hasOne('App\Models\ProductAttribute', 'product_id');
    }

    public function visits()
    {
        return $this->hasMany(ProductVisit::class, 'product_id');
    }

    public function comboProduct()
    {
        return $this->hasMany('App\Models\ComboProduct', 'product_id');
    }

    public function comboProducts()
    {
        return $this->hasMany(ComboProduct::class, 'combo_product_id');
    }

    public function variants()  
    {
        return $this->hasMany(ProductVariant::class, 'product_id');
    }

    public function productVariant()
    {
        return $this->hasMany('App\Models\ProductVariant', 'product_id');
    }

    public  function supplier()
    {
        return $this->belongsTo('App\Models\Supplier', 'merchant_id');
    }



    public function purchaseItem()
    {
        return $this->hasMany('App\Models\PurchaseItem', 'product_id');
    }


    public function category()
    {
        return $this->belongsTo('App\Models\Category', 'category_id');
    }

    public function subCategory()
    {
        return $this->belongsTo('App\Models\SubCategory', 'sub_category_id');
    }

    public function subSubCategory()
    {
        return $this->belongsTo('App\Models\SubSubCategory', 'sub_sub_category_id');
    }

    public function brand()
    {
        return $this->belongsTo('App\Models\Brand', 'brand_id');
    }

    public function productReviews()
    {
        return $this->hasMany('App\Models\ProductReview', 'product_id');
    }



    public function merchant()
    {

        return $this->belongsTo('App\Models\Merchant', 'merchant_id');
    }

    public function carts()
    {
        return $this->hasMany('App\Models\Cart', 'product_id');
    }


    public function orderItems()
    {
        return $this->hasMany(OrderItem::class);
    }

    public function saleItems()
    {
        return $this->hasMany(SaleItem::class);
    }


    protected static function booted()
    {
        static::deleting(function ($product) {
            $product->productImage()->delete();
            $product->productReviews()->delete();
            $product->productVariant()->delete();
            $product->orderItems()->delete();
            $product->saleItems()->delete();
        });
    }



    public function resellerProductPrice()
    {
        return $this->hasMany('App\Models\ResellerProductPrice', 'product_id');
    }



    public function skin()
    {
        return $this->belongsTo('App\Models\Skin', 'skin_id');
    }
    
    public function productCategory()
    {
        return $this->hasMany('App\Models\ProductCategory', 'product_id');
    }

    public function productSubCategory()
    {
        return $this->hasMany('App\Models\ProductSubCategory', 'product_id');
    }

    public function productSubSubCategory()
    {
        return $this->hasMany('App\Models\ProductSubSubCategory', 'product_id');
    }


    public function country()
    {
        return $this->belongsTo('App\Models\SubSubCategory', 'sub_sub_category_id');
    }
}
