<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductCategory extends Model
{
   protected $table = 'product_categories';
   protected $fillable = ['id', 'product_id', 'category_id', 'created_at', 'updated_at'];

   public function category(){
      return $this->belongsTo('App\Models\Category','category_id');
   }

   public function product(){
      return $this->belongsTo(Product::class,'product_id','id');
   }

}
