<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductSkin extends Model
{
    protected $table = 'product_skins';
    protected $fillable = ['id', 'product_id', 'skin_id', 'created_at', 'updated_at'];
 
    public function skin(){
       return $this->belongsTo('App\Models\Skin','skin_id');
    }
 
    public function product(){
       return $this->belongsTo(Product::class,'product_id','id');
    }
}
