<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductVariant extends Model
{
    protected $table = 'product_variants' ;

   protected $fillable = ['product_id','variant_id','attribute_id','price','stock','image','status'];
    
    
    public function variant(){
        return $this->belongsTo('App\Models\Variant','variant_id');
    }

    public function attribute(){
        return $this->belongsTo('App\Models\Attribute','attribute_id');
    }

    public function product() 
    {
        return $this->belongsTo(Product::class, 'product_id');
    }

}
