<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DateTimeInterface;

class ProductVisit extends Model
{
    use HasFactory;
    protected $table = 'product_visits';
    protected $fillable = [
        'id',
        'product_id',
        'session_id',
        'ip',
        'qty',
        'visit_time',
        'created_at',
        'updated_at'
    ];


    public function product()
    {
        return $this->belongsTo('App\Models\Product', 'product_id');
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}
