<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use DateTimeInterface;

class ResellerCashbook extends Model
{
    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }

    protected $fillable = ['id', 'invoice_no', 'reseller_id', 'order_id', 'payment_method_id', 'amount', 'is_discount', 'reference', 'is_income', 'attachment', 'paid_date', 'note', 'created_by', 'created_at', 'updated_at'];
    public function order()
    {
        return $this->belongsTo('App\Models\Order','order_id');
    }
    



}
