<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DateTimeInterface;

class ResellerPaymentTransaction extends Model
{
     protected function serializeDate(DateTimeInterface $date)
     {
         return $date->format('Y-m-d H:i:s');
     }

       protected $fillable = ['id', 'reseller_id', 'payment_method', 'account_no', 'transaction_id', 'amount', 'status', 'note', 'created_at', 'updated_at'] ;

       public function reseller() {

            return $this->belongsTo('App\Models\Reseller','reseller_id') ;
       }


       public function bank(){
          return $this->belongsTo('App\Models\Bank','account_no');
      }
}
