<?php

namespace App\Models;

use App\Models\ResellerPaymentTransaction;
use Illuminate\Database\Eloquent\Model;
use DateTimeInterface;

class ResellerPaymentTransactionDetail extends Model
{
    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
    public function order() {
        return $this->belongsTo('App\Models\Order');
    }

    public function paymentTransaction() {
        return $this->belongsTo('App\Models\ResellerPaymentTransaction', 'reseller_payment_transaction_id');
    }
}
