<?php

namespace App\Providers;

use App\Models\Category;
use App\Services\HelperService;
use Illuminate\Support\Facades\DB;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Schema;
use App\View\Composers\GeneralComposer;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        $rememberToken =  HelperService::siteRememberToken();
        $getSiteToken = request()->getHost();
        if (substr($getSiteToken, 0, 4) == 'www.') {
            $getSiteToken  = substr($getSiteToken, 4);
        }
        $siteToken = hash('sha256', $getSiteToken);
        if ($rememberToken == $siteToken) {
            $categories = Category::with(['subCategory:id,name,slug,status,category_id', 'subSubCategory:id,name,slug,status,category_id,subcategory_id'])
                ->select('id', 'name', 'slug', 'status')
                ->where('status', 1)->orderBy('position', 'ASC')->limit(13)->get();
            Paginator::useBootstrap();
            Schema::defaultStringLength(191);
            View::composer(['frontend.app'], GeneralComposer::class);
            $general_settings   = DB::table('general_settings')->first();
            $site_configurations   = DB::table('site_configurations')->first();
            View::share('site_configurations', $site_configurations);
            View::share('general_settings', $general_settings);
            View::share('categories', $categories);

        }

    }
}
