<?php

namespace App\Providers;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\ServiceProvider;

class DynamicConfigServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $socialLogin = DB::table('general_settings')->first();

        if ($socialLogin) {
            config([
                'services.google.client_id' => $socialLogin->google_client_id,
                'services.google.client_secret' => $socialLogin->google_client_secret,
                'services.google.redirect' => $socialLogin->google_redirect,

                'services.facebook.client_id' => $socialLogin->facebook_app_id,
                'services.facebook.client_secret' => $socialLogin->facebook_app_secret,
                'services.facebook.redirect' => $socialLogin->facebook_redirect,
            ]);
        }
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }
}