<?php

namespace App\Providers;

use Illuminate\Support\Facades\Route;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use App\Services\HelperService;
class RouteServiceProvider extends ServiceProvider
{
    /**
     * This namespace is applied to your controller routes.
     *
     * In addition, it is set as the URL generator's root namespace.
     *
     * @var string
     */
    protected $namespace = 'App\Http\Controllers';
    public const HOME = '/';
    public const DASHBOARD = '/user/dashboard';
    /**
     * Define your route model bindings, pattern filters, etc.
     *
     * @return void
     */
    public function boot()
    {
        //

        parent::boot();
    }

    /**
     * Define the routes for the application.
     *
     * @return void
     */
    public function map()
    {
        $this->mapApiRoutes();

        $this->mapWebRoutes();

        //
    }

    /**
     * Define the "web" routes for the application.
     *
     * These routes all receive session state, CSRF protection, etc.
     *
     * @return void
     */
    protected function mapWebRoutes()
    {
        $rememberToken =  HelperService::siteRememberToken();
        $getSiteToken = request()->getHost();
        if (substr($getSiteToken, 0, 4) == 'www.') {
            $getSiteToken  = substr($getSiteToken, 4);
        }
        $siteToken = hash('sha256', $getSiteToken);
        if ($rememberToken == $siteToken) {
            Route::middleware('web')
                ->namespace($this->namespace)
                ->group(base_path('routes/web.php'));


            Route::middleware('web')
                ->namespace($this->namespace)
                ->group(base_path('routes/public.php'));
            
            Route::middleware('web')
                    ->namespace($this->namespace)
                    ->group(base_path('routes/reseller.php'));
            Route::middleware('web')
                    ->namespace($this->namespace)
                    ->group(base_path('routes/merchant.php'));  


        }     

             

    }


 
    /**
     * Define the "api" routes for the application.
     *
     * These routes are typically stateless.
     *
     * @return void
     */
    protected function mapApiRoutes()
    {
        Route::prefix('api')
             ->middleware('api')
             ->namespace($this->namespace)
             ->group(base_path('routes/api.php'));
    }
}
