<?php

namespace App\Services;

use Intervention\Image\Facades\Image;
use App\Models\ProductImage;
use App\Models\LandingPageReview;
use App\Models\BookAttachmentsImg;
use Illuminate\Support\Facades\Storage;

trait  FileUpload
{


    public static function singleFileUpload($file, $dir_name)
    {
        $path = $file->store('images/' . $dir_name, 'public');
        return $path;
    }

    public static function productMultiFileUpload($files, $product_id)
    {
        $storagePath = 'public/images/products/';

        if (!Storage::exists($storagePath)) {
            Storage::makeDirectory($storagePath, 0755, true, true);
        }

        foreach ($files as $key => $file) {
            if (is_string($file) && strlen($file) > 6 && preg_match('/^data:image\/(\w+);base64,/', $file)) {
                try {
                    $image_data = substr($file, strpos($file, ',') + 1);
                    $image_data = base64_decode($image_data);

                    if ($image_data === false) {
                        throw new \Exception('Base64 decode failed.');
                    }

                    $path = 'product_' . time() . '_' . rand(1111, 9999) . '.jpg';

                    Storage::put($storagePath . $path, $image_data);

                    $image_resize = Image::make(Storage::path($storagePath . $path));
                    $image_resize->save(Storage::path($storagePath . $path));

                    $p_c_image = new ProductImage();
                    $p_c_image->product_id = $product_id;
                    $p_c_image->image = 'images/products/' . $path;
                    $p_c_image->save();
                } catch (\Exception $e) {
                    throw new \Exception("MultiFileUpload Error: " . $e->getMessage());
                }
            }
        }
    }

    //   public static function productMultiFileUpload($files,$product_id)
    //   {
    //         foreach ($files as $key => $file) {
    //            if (strlen($file) > 6) {
    //                 $p_c_image = new ProductImage() ;
    //                 $path = 'product_'.time().'_'.rand(1111,9999).'.jpg';
    //                 Image::make(file_get_contents($file))->save(public_path('storage/images/products/').$path);
    //                 $p_c_image->product_id = $product_id ;
    //                 $p_c_image->image = 'images/products/'.$path;

    //                 $p_c_image->save();
    //            }

    //         }

    //       return;
    //   }

    public static function landingPageReview($files, $page_id)
    {
        $storagePath = 'public/images/review/';

        if (!Storage::exists($storagePath)) {
            Storage::makeDirectory($storagePath, 0755, true, true);
        }

        foreach ($files as $file) {
            if (is_string($file) && strlen($file) > 6 && preg_match('/^data:image\/(\w+);base64,/', $file)) {
                try {
                    $image_data = substr($file, strpos($file, ',') + 1);
                    $image_data = base64_decode($image_data);

                    if ($image_data === false) {
                        throw new \Exception('Base64 decode failed.');
                    }

                    $path = 'review_' . time() . '_' . rand(1111, 9999) . '.jpg';

                    Storage::put($storagePath . $path, $image_data);

                    $image_resize = Image::make(Storage::path($storagePath . $path));
                    $image_resize->save(Storage::path($storagePath . $path));

                    $review = new LandingPageReview();
                    $review->landing_page_id = $page_id;
                    $review->thumbnail_img = 'images/review/' . $path;
                    $review->save();
                } catch (\Exception $e) {
                    throw new \Exception("MultiFileUpload Error: " . $e->getMessage());
                }
            }
        }
    }
    //   public static function landingPageReview($files,$page_id)
    //   {
    //     foreach ($files as $key => $file) {
    //         if (strlen($file) > 6) {
    //             $review = new LandingPageReview() ;
    //             $path = 'review_'.time().'_'.rand(1111,9999).'.jpg';
    //             Image::make(file_get_contents($file))->save(public_path('storage/images/review/').$path);
    //             $review->landing_page_id = $page_id ;
    //             $review->thumbnail_img = 'images/review/'.$path;
    //             $review->save();
    //         }

    //     }
    //     return;
    //   }


    public static function singleFileUploadWithIntervention($file, $dir_name, $width = 300, $height = 300)
    {

        //make thumbnail image
        $filename = time() . $file->getClientOriginalName();
        $image_resize = Image::make($file->getRealPath());
        $image_resize->resize($width, $height);
        $image_resize->save(public_path('storage/images/' . $dir_name . '/' . $filename));
        return $filename;
    }



    public static function productUploadWithIntervention($files, $product_id)
    {
        foreach ($files as $key => $file) {
            $p_c_image = new ProductImage();
            $path = 'product_' . time() . '_' . rand(1111, 9999) . '.jpg';
            Image::make(file_get_contents($file))->save(public_path('storage/images/products/') . $path);
            $p_c_image->product_id = $product_id;
            $p_c_image->image = 'images/product/' . $path;
            $p_c_image->save();
        }
        return;
    }




    public static function fileUnlink($path)
    {

        return  unlink($path);
    }

    public static function bookMultiFileUpload($files, $product_id)
    {
        $storagePath = 'public/images/books/'; 
    
        if (!Storage::exists($storagePath)) {
            Storage::makeDirectory($storagePath, 0755, true, true);
        }
    
        foreach ($files as $file) {
            if (is_string($file) && strlen($file) > 6 && preg_match('/^data:image\/(\w+);base64,/', $file)) {
                try {
                    $image_data = substr($file, strpos($file, ',') + 1);
                    $image_data = base64_decode($image_data);
    
                    if ($image_data === false) {
                        throw new \Exception('Base64 decode failed.');
                    }
    
                    $path = 'book_' . time() . '_' . rand(1111, 9999) . '.jpg';
    
                    Storage::put($storagePath . $path, $image_data);
    
                    $image_resize = Image::make(Storage::path($storagePath . $path));
                    $image_resize->save(Storage::path($storagePath . $path));
    
                    $bookImage = new BookAttachmentsImg();
                    $bookImage->product_id = $product_id;
                    $bookImage->image = 'images/books/' . $path;
                    $bookImage->save();
                } catch (\Exception $e) {
                    throw new \Exception("bookMultiFileUpload Error: " . $e->getMessage());

                }
            }
        }
    }
}
