<?php 
namespace App\Services;

use App\Models\Product;
use Illuminate\Support\Facades\DB;

class FrontendService{

    public static function productIds($column_name,$column_value){
        return DB::table('products')->where($column_name, $column_value)->where('show_homepage', 1)->select('id')->pluck('id');
    }

    public static function productFetcher($products_ids)
    {
        return  Product::whereIn('id', $products_ids)
                        ->with('author:id,name','publisher:id,name')
                        ->select('id','category_id', 'brand_id','name','stock','status','thumbnail_img','slug','sale_price','discount','price','reselling_price','is_free_delivery','review_ratings','avg_review','author_id','publisher_id')
                        ->where('status', 1)
                        ->inRandomOrder()
                        ->latest()
                        ->paginate(12);
    }

    public static function productIdForBrand($column_name, $column_value)
    {
        return DB::table('products')->where($column_name, $column_value)->where('show_homepage', 1)->select('id')->pluck('id');
    }

    public static function brandProductFetcher($products_ids)
    {
        return  Product::whereIn('id', $products_ids)
            ->with('author:id,name', 'publisher:id,name')
            ->select('id', 'brand_id', 'name', 'stock', 'status', 'thumbnail_img', 'slug', 'sale_price', 'discount', 'price', 'reselling_price', 'is_free_delivery', 'review_ratings', 'avg_review', 'author_id', 'publisher_id')
            ->where('status', 1)
            ->inRandomOrder()
            ->latest()
            ->paginate(12);
    }

    public static function getProducts(){
        return DB::table('products')->select(
            'id',
            'category_id',
            'name',
            'status',
            'thumbnail_img',
            'slug',
            'stock',
            'sale_price',
            'discount',
            'price',
            'reselling_price',
            'is_free_delivery',
            'review_ratings', 
            'avg_review'
            )
            ->where('select_home_page', 1)
            ->where('status', 1)
            ->inRandomOrder();
    }
    
    public static function relatedProducts($product_id, $category_id, $sub_category_id, $sub_sub_category_id,$position_wise_product){

        $query = Product::where('id', '!=', $product_id)
            ->select('id', 'category_id', 'sub_category_id', 'sub_sub_category_id', 'name', 'product_code', 'thumbnail_img', 'slug', 'stock', 'sale_price', 'discount', 'price', 'stock', 'status', 'details', 'is_free_delivery', 'review_ratings', 'author_id', 'publisher_id', 'avg_review', 'created_at')
            ->with(['productVariant:id,product_id,variant_id,attribute_id,price', 'productVariant.variant:id,name,status', 'author:id,name', 'publisher:id,name'])
            ->when($sub_sub_category_id, function ($q, $sub_sub_category_id) {
                $q->where('sub_sub_category_id', $sub_sub_category_id);
            })
            ->when($sub_category_id, function ($q, $sub_category_id) {
                $q->where('sub_category_id', $sub_category_id);
            })
            ->when($category_id, function ($q, $category_id) {
                $q->where('category_id', $category_id);
            })
            ->where('status', 1);

        if ($position_wise_product == 1) {
            $query->orderBy('product_position', 'asc');
        } else {
            $query->orderBy('id', 'desc');
        }
        return $query->get();
    }





}