<?php

namespace App\Services;

use Illuminate\Support\Facades\Log;

class LogTracker
{
    public static function failLog(\Throwable $exception, $context = null)
    {
        $message = $exception->getMessage();
        $context = $context ?? [];
        Log::error($message, $context);
    }

    public static function successLog($message, $context = null)
    {
        $context = $context ?? [];
        Log::info($message, $context);
    }
    public static function infoLog($message)
    {
        Log::info($message);
    }
}

