<?php

namespace App\Traits;

use App\Models\Variant;
use App\Models\ProductVariant;

trait CalculateProductSalePriceTrait
{
    public function calculateSalePrice($request, $product)
    {
        $variants = $request->variants ?? []; // Get the variants from the request
        $product_sale_price = $product->sale_price; 
        // Loop through each variant to calculate the price based on the first matching variant
        foreach ($variants as $variantAtr => $variantName) {
            $variant = $this->getVariantByName($variantName);
            if ($variant) {
                $variant_price = $this->getVariantPrice($variant->id, $product->id);
                if ($variant_price) {
                    $product_sale_price = $this->getProductSalePrice($variant_price, $product->sale_price);
                    break; // Stop after finding the first matching variant price
                }
            }
        }

        return $product_sale_price;
    }

    private function getVariantByName($name)
    {
        return Variant::where('name', $name)
            ->first();
    }

    private function getVariantPrice($variantId, $productId)
    {
        return ProductVariant::select('price')
            ->where('variant_id', $variantId)
            ->where('product_id', $productId)
            ->first();
    }


    private function getProductSalePrice($variant_price, $default_price)
    {
        if ($variant_price) {
            return $variant_price->price > 0 ? $variant_price->price : $default_price;
        } else {
            return $default_price;
        }
    }
}