<?php

namespace App\Traits;

use App\Models\Product;
use App\Models\ProductReview;
use Illuminate\Http\Request;
trait FilterProductTrait
{
    public function filterByType(Request $request, $type,$typeId)
    {
      $brand_ids = $request->input($type, []);

      $query = Product::where('status', 1)->select('id', 'category_id', 'name', 'status', 'thumbnail_img', 'video_url', 'slug','stock', 'sale_price', 'discount', 'price');
      if ($brand_ids) {
          $query->whereIn($typeId, $brand_ids);
          // Get filtered products
          $products = $query->get();
      } else {
          $products = $query->get();
      }
      return $products;
    }
}


