<?php

namespace App\Traits;

use App\Models\Product;
use Illuminate\Support\Facades\DB;

trait TypeWiseProducts
{
    public function typeWiseProducts($productType)
    {
        $products = Product::select(
            'id',
            'name',
            'product_code',
            'price',
            'sale_price',
            'review_ratings',
            'avg_review',
            'slug',
            'stock',
            'discount',
            'thumbnail_img',
            'created_at'
        )->where($productType, 1)->where('status', 1)->where('select_home_page', 1)->orderBy('id', 'desc')->get();
        return $products; 
    }
    

    public function renderProductView($type)
    {
        $products = $this->typeWiseProducts([$type => 1]);
        $is_combo = $type === 'is_combo' ? 1 : 0;
        $is_daily_offer = $type === 'is_daily_offer' ? 1 : 0;
        $is_buy_one_get_one = $type === 'is_buy_one_get_one' ? 1 : 0;

        return view('frontend.components.offer_products', compact('products', 'is_combo', 'is_daily_offer', 'is_buy_one_get_one'));
    }
    public function conrcenWiseProduct($productType, $produuctId)
    {
        $products = Product::select(
            'id',
            'name',
            'product_code',
            'price',
            'sale_price',
            'review_ratings',
            'avg_review',
            'slug',
            'stock',
            'discount',
            'thumbnail_img',
            'created_at'
        )->where($productType, $produuctId)->where('status', 1)->orderBy('id', 'desc')->get();
        return $products;
    }
    public function shopByProducts($dbName)
    {
        $shop_by_products = DB::table($dbName)
            ->where('status', 1)
            ->get();

        return $shop_by_products;
    }
}
