<?php

namespace App\View\Composers;

use App\Models\Category;
use Illuminate\View\View;
use Illuminate\Support\Facades\DB;
use Gloudemans\Shoppingcart\Facades\Cart;
use App\Services\HelperService;
use App\Models\SiteConfiguration;


class GeneralComposer {

    public function __construct() {
        //
    }

    public function compose(View $view): void
    {
        $template = SiteConfiguration::select('template_id')->first();
        $rememberToken =  HelperService::siteRememberToken();
        $getSiteToken = request()->getHost();
        if (substr($getSiteToken, 0, 4) == 'www.') {
            $getSiteToken  = substr($getSiteToken, 4);
        }
        $siteToken = hash('sha256', $getSiteToken);
        if ($rememberToken == $siteToken) {
            if($template->template_id == 3){
                $categories = Category::with(['subCategory:id,name,slug,status,category_id','subSubCategory:id,name,slug,status,category_id,subcategory_id'])
                                    ->select('id','name','slug','status')    
                                    ->where('status', 1)->orderBy('position', 'ASC')->limit(5)->get();
            }else {
                $categories = Category::with(['subCategory:id,name,slug,status,category_id','subSubCategory:id,name,slug,status,category_id,subcategory_id'])
                ->select('id','name','slug','status')    
                ->where('status', 1)->orderBy('position', 'ASC')->limit(15)->get();
            }
            
            
            $footer_settings    = DB::table('footer_settings')->first();
            $pages = DB::table('pages')->where('status',1)->get();
            $view->with([
                "categories"        => $categories,
                'footer_settings'   => $footer_settings,
                'pages'             => $pages,
            ]);
        }
    }


}