<?php
    $admin = null;
    if (session()->has('admin')) {
        $admin = session()->get('admin');
        $site_configuration = App\Models\SiteConfiguration::first();
    }
?>
<aside class="main-sidebar">

    <!-- =========== Desktop Device Start =========== -->
    <section class="sidebar sidebar_desktop_device">

        <!-- Sidebar user panel -->
        <div class="user-panel" style="border-bottom:1px solid rgba(106, 113, 133, 0.2)">

            <div class="pull-left image">
                @if ($admin != null && !empty($admin->image))
                    <img src="{{ asset('storage/' . $admin->image) }}" class="img-circle" alt="User Image">
                @else
                    <img src="{{ asset('admin/dist/img/user2-160x160.jpg') }}" class="img-circle" alt="User Image">
                @endif
            </div>
            <div class="pull-left info" style="top:1px;">
                @if ($admin != null)
                    <h4 style="color: #000000;">{{ explode(' ', trim($admin->name))[0] }}</h4>
                @endif
                <a style="color: #9FA8C1" href="#"><i class="fa fa-circle text-success"></i> Online</a>
                <br>
            </div>

            <div class="sidebar_search">
                <form action="#">
                    <input type="text" placeholder="search menu...." id="search_input" onkeyup="search()">
                </form>
            </div>

        </div>
        

        <div class="sidebar_content">
            <div class="main_menu">
                <ul class="sidebar-menu" id="sidebar-menu" data-widget="tree">

                    <li class="treeview">
                        <a href="#">
                            <svg stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"
                                xmlns="http://www.w3.org/2000/svg" fill="none">
                                <path
                                    d="M4 5a1 1 0 0 1 1-1h4a1 1 0 0 1 1 1v5a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V5ZM14 5a1 1 0 0 1 1-1h4a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1h-4a1 1 0 0 1-1-1V5ZM4 16a1 1 0 0 1 1-1h4a1 1 0 0 1 1 1v3a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1v-3ZM14 13a1 1 0 0 1 1-1h4a1 1 0 0 1 1 1v6a1 1 0 0 1-1 1h-4a1 1 0 0 1-1-1v-6Z" />
                            </svg>
                            <span>
                                <router-link :to="{ name: 'dashboard' }">Dashboard</router-link>
                            </span>
                        </a>
                    </li>

                    @if ($admin->can('manage Order'))
                        <li class="treeview order_m">
                            <a href="#">
                           <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-shopping-bag"><path d="M6 2L3 6v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2V6l-3-4z"></path><line x1="3" y1="6" x2="21" y2="6"></line><path d="M16 10a4 4 0 0 1-8 0"></path></svg>
                                <span>Orders</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><router-link :to="{ name: 'order_stage', params: { status_code: 'all', type: 'all' } }"> Manage Order </router-link></li>
                                <li><router-link :to="{ name: 'add_exchange_order'}">  Add Exchange Order </router-link></li>
                                <li><router-link :to="{ name: 'order_processing_report' }">Order Processing Report</router-link></li>
                                <li><router-link :to="{ name: 'order_source' }">Order Source</router-link></li>
                                <li><router-link :to="{ name: 'comment' }">Order Processing Note</router-link></li>
                                <li><router-link :to="{ name: 'courier' }">Courier</router-link></li>
                            </ul>
                        </li>
                    @endif

                    @if ($admin->can('manage Sale'))
                        <li class="treeview">
                            <a href="#">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-file-analytics"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M14 3v4a1 1 0 0 0 1 1h4"></path><path d="M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z"></path><path d="M9 17l0 -5"></path><path d="M12 17l0 -1"></path><path d="M15 17l0 -3"></path></svg>
                                <span>Sale</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><router-link :to="{ name: 'officeSale' }">OfficeSale</router-link></li>
                                {{-- <li><router-link :to="{ name: 'inventory' }">POS</router-link></li> --}}
                                {{-- <li><router-link :to="{ name: 'compnaySale' }">Wholesale</router-link></li>
                                <li><router-link :to="{ name: 'company' }">Wholeseller</router-link></li> --}}
                            </ul>
                        </li>
                    @endif

                       @if ($admin->can('manage product'))
                        <li class="treeview">
                            <a href="#">
                             <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-shirt"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M15 4l6 2v5h-3v8a1 1 0 0 1 -1 1h-10a1 1 0 0 1 -1 -1v-8h-3v-5l6 -2a3 3 0 0 0 6 0"></path></svg>
                                <span>Products</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="/admin/products/1">Manage Products</a></li>

                                <li><router-link :to="{ name: 'attribute' }">Attribute/Size</router-link></li>
                                <li><router-link :to="{ name: 'variant' }">Variant</router-link></li>

                                    @if ($admin->can('manage purchase'))
                                        @if ($site_configuration->variant_wise_stock == 1)
                                           <li><router-link :to="{ name: 'variantPurchase' }">Products Purchase</router-link></li>
                                        @else
                                           <li><router-link :to="{ name: 'purchase' }">Products Purchase</router-link></li>
                                        @endif
                                    @endif

                                <li><router-link :to="{ name: 'customer_review' }">Products Review</router-link></li>

                                <li>
                                    <router-link :to="{ name: 'product_view_report' }"> Product View Report
                                    </router-link>
                                </li>

                                @if ($site_configuration->template_id == 4)
                                    <li>
                                        <a href="/admin/author"><i class="fa fa-circle-o"></i> Authors </a>
                                    </li>
                                    <li>
                                        <a href="/admin/publisher"><i class="fa fa-circle-o"></i> Publishers </a>
                                    </li>
                                @endif

                                @if ($site_configuration->template_id == 9)
                                    <li>
                                        <router-link :to="{ name: 'country' }"> Country </router-link>
                                    </li>
                                    <li>
                                        <router-link :to="{ name: 'skin' }"> Skin </router-link>
                                    </li>
                                @endif

                                <li><router-link :to="{ name: 'combo_products' }">Combo Products</router-link></li>

                                <li>
                                    <router-link :to="{ name: 'FreeDeliveryProducts' }">Free Delivery Products</router-link>
                                </li>

                                   <li>                                    
                                    <router-link :to="{ name: 'manageDamageProduct' }">Damage Products</router-link>
                                </li>

                                   <li>                                    
                                    <router-link :to="{ name: 'supplier' }">Supplier Manage</router-link>
                                </li>

                            </ul>
                        </li>
                    @endif

                    
              

                      @if ($admin->can('manage category'))
                        <li class="treeview">
                            <a href="#">
                                <svg fill="none" stroke="currentColor" viewBox="0 0 24 24" class="w-5 h-5"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path></svg>
                                <span>Category</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><router-link :to="{ name: 'category' }">Main Category</router-link></li>
                                <li><router-link :to="{ name: 'SubCategory' }">Sub Category</router-link></li>
                                <li><router-link :to="{ name: 'subSubCategory' }">Sub Sub Category</router-link></li>
                            </ul>
                        </li>
                    @endif

                     @if ($admin->can('manage slider'))
                        <li class="treeview">
                            <a href="#">
                               <svg fill="none" stroke="currentColor" viewBox="0 0 24 24" class="w-5 h-5"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                                <span>Slider</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><router-link :to="{ name: 'slider' }">Sliders</router-link></li>
                            </ul>
                        </li>
                    @endif

                     @if ($admin->can('manage category'))
                        <li class="treeview">
                            <a href="#">
                                <svg fill="none" stroke="currentColor" viewBox="0 0 24 24" class="w-5 h-5"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z"></path></svg>
                                <span>Brand</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><router-link :to="{ name: 'brand' }">Brands</router-link></li>
                            </ul>
                        </li>
                    @endif



                    @if ($admin->can('Manage accounts'))
                        <li class="treeview">
                            <a href="#">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-receipt-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M5 21v-16a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v16l-3 -2l-2 2l-2 -2l-2 2l-2 -2l-3 2"></path><path d="M14 8h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5m2 0v1.5m0 -9v1.5"></path></svg>
                                <span>Accounts</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><router-link :to="{ name: 'credit' }">Income</router-link></li>
                                <li><router-link :to="{ name: 'debit' }">Expense</router-link></li>
                                <li><router-link :to="{ name: 'CreditDue' }">Due</router-link></li>
                                {{-- <li><router-link :to="{ name: 'all_balance' }">Mange Balance </router-link></li> --}}
                                <li><router-link :to="{ name: 'balance' }">Balance</router-link></li>
                                <li><router-link :to="{ name: 'fondtransfer' }">Fund Transfer</router-link></li>
                                <li><router-link :to="{ name: 'account_purpose' }">Account Purpose </router-link></li>
                                <li><router-link :to="{ name: 'team_member' }">Employee Salary</router-link></li>
                                <li><router-link :to="{ name: 'bill_statement' }">Bill Statements </router-link></li>

                                @if ($site_configuration->affiliate_active == 1)
                                    <li><a href="/admin/withdrawal">Affiliate Withdraw History </a></li>
                                    {{-- <li><a href="/admin/influencer/withdrawal">Influencer Withdraw History </a></li> --}}
                                @endif
                            </ul>
                        </li>
                    @endif

                 


                    

{{-- 
                    @if ($admin->can('manage supplier'))
                        <li class="treeview">
                            <a href="#">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                    stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round" class="feather feather-truck">
                                    <rect x="1" y="3" width="15" height="13"></rect>
                                    <polygon points="16 8 20 8 23 11 23 16 16 16 16 8"></polygon>
                                    <circle cx="5.5" cy="18.5" r="2.5"></circle>
                                    <circle cx="18.5" cy="18.5" r="2.5"></circle>
                                </svg>
                                <span>Product Supplier</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><router-link :to="{ name: 'supplierAdd' }">Add</router-link></li>
                                <li><router-link :to="{ name: 'supplier' }">Manage</router-link></li>
                            </ul>
                        </li>
                    @endif --}}

                  
                   
                   







                    @if ($admin->can('manage basic set up'))

                        <li class="treeview">
                            <a href="#">
                               <svg fill="none" stroke="currentColor" viewBox="0 0 24 24" class="w-5 h-5"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9"></path></svg>
                                <span>Website Setup</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><router-link :to="{ name: 'header_setting' }">Header</router-link></li>
                                <li><router-link :to="{ name: 'footer_setting' }">Footer</router-link></li>
                                <li><router-link :to="{ name: 'theme_setting' }">Theme Color</router-link></li>
                                <li><router-link :to="{ name: 'font_family' }">Font Family</router-link></li>
                                <li><router-link :to="{ name: 'page_list' }">Pages</router-link></li>
                            </ul>
                        </li>
                        {{-- <li class="treeview">
                            <a href="#">
                                <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 256 256" xmlns="http://www.w3.org/2000/svg"><path d="M64,64l40,120H24ZM200,76a44,44,0,1,0-44,44A44,44,0,0,0,200,76Zm-64,76v56h88V152Z" opacity="0.2"></path><path d="M224,144H136a8,8,0,0,0-8,8v56a8,8,0,0,0,8,8h88a8,8,0,0,0,8-8V152A8,8,0,0,0,224,144Zm-8,56H144V160h72ZM71.59,61.47a8,8,0,0,0-15.18,0l-40,120A8,8,0,0,0,24,192h80a8,8,0,0,0,7.59-10.53ZM35.1,176,64,89.3,92.9,176ZM208,76a52,52,0,1,0-52,52A52.06,52.06,0,0,0,208,76Zm-88,0a36,36,0,1,1,36,36A36,36,0,0,1,120,76Z"></path></svg>
                                <span>Site Configuration</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><router-link :to="{ name: 'site_configuration' }">Configuration</router-link></li>
                            </ul>
                        </li> --}}
                        <li class="treeview">
                            <a href="#">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2"
                                    stroke="currentColor" fill="none">
                                    <path
                                        d="M10.325 4.317c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.756 .426 1.756 2.924 0 3.35a1.724 1.724 0 0 0 -1.066 2.573c.94 1.543 -.826 3.31 -2.37 2.37a1.724 1.724 0 0 0 -2.572 1.065c-.426 1.756 -2.924 1.756 -3.35 0a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065z">
                                    </path>
                                    <path d="M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0"></path>
                                </svg>
                                <span>Setting & Configuration</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><router-link :to="{ name: 'marketing_setting' }">Marketing</router-link></li>
                                {{-- @if ($site_configuration->sms_on == 1)
                                <li><router-link :to="{ name: 'sms_service_edit' }">SMS API</router-link></li>   
                                @endif --}}
                                <li><router-link :to="{ name: 'courier_api_setup' }">Courier API</router-link></li>
                                @if ($site_configuration->bkash_active == 1)
                                    <li><router-link :to="{ name: 'bkash_setup' }">Bkash API</router-link></li>
                                @endif
                                @if ($site_configuration->amarpay_active == 1)
                                    <li><router-link :to="{ name: 'amarpay_setup' }">Amarpay API</router-link></li>
                                @endif
                                <li><router-link :to="{ name: 'general_setting' }">Invoice Address</router-link></li>
                                <li><router-link :to="{ name: 'delivery_charge' }">Delivery Charge</router-link></li>
                                <li><router-link :to="{ name: 'social_login' }">Social Login</router-link></li>
                                <li><router-link :to="{ name: 'city' }">City</router-link></li>
                                <li><router-link :to="{ name: 'sub_city' }">Sub City </router-link></li>
                                

                            </ul>
                        </li>


                        <li class="treeview">
                            <a href="#">
                                <svg stroke-width="1.5" stroke="currentColor" fill="currentColor"
                                    xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="-43.92 -43.92 527.06 527.06"
                                    xml:space="preserve" transform="rotate(0)matrix(-1, 0, 0, 1, 0, 0)">
                                    <path
                                        d="M432.719,387.222h-22.153c-1.49,0-2.936,0.512-4.094,1.451c-22.218,18.013-50.205,27.934-78.806,27.934H315.19 c2.443-3.909,3.934-8.47,4.144-13.358l8.637-2.484c15.605-4.497,24.643-20.851,20.146-36.455l-9.784-33.965 c7.844,5.077,17.178,8.039,27.197,8.039c3.59,0,6.5-2.91,6.5-6.5s-2.91-6.5-6.5-6.5c-20.513,0-37.201-16.688-37.201-37.201 l-0.029-35.912c0-3.59-2.91-6.5-6.5-6.5s-6.5,2.91-6.5,6.5v36.457c0,8.91-7.249,16.159-16.159,16.159s-16.158-7.249-16.158-16.159 v-49.554c0-5.311,4.321-9.632,9.632-9.632h49.948c19.094,0,37.101,9.289,48.162,24.842l0.118,0.166 c8.998,12.65,23.638,20.203,39.161,20.203c3.59,0,6.5-2.91,6.5-6.5s-2.91-6.5-6.5-6.5c-11.324,0-22.004-5.509-28.563-14.731 l-0.118-0.166c-8.471-11.91-20.276-20.806-33.65-25.783c24.162-12.021,40.811-36.962,40.811-65.73 c0-40.461-32.918-73.379-73.38-73.379l-73.247-0.007c-72.942,0-146.052-24.599-211.422-71.138 c-1.981-1.411-4.585-1.598-6.748-0.482s-3.521,3.344-3.521,5.777l0,73.802C15.633,102.363,0,127.582,0,155.348 c0,27.754,15.634,52.973,40.168,65.42l0,73.795c0,2.433,1.358,4.662,3.521,5.777c0.938,0.484,1.96,0.723,2.978,0.723 c1.328,0,2.649-0.406,3.771-1.205c55.427-39.46,116.417-63.139,178.152-69.432l6.53,17.706h-2.155 c-15.196,0-27.559,12.363-27.559,27.559c0,6.995,2.624,13.386,6.934,18.251c-8.245,4.769-13.808,13.678-13.808,23.868 c0,10.269,5.65,19.238,14.001,23.979c-4.252,4.851-6.838,11.197-6.838,18.14c0,13.348,9.539,24.506,22.158,27.024 c-2.852,4.339-4.518,9.525-4.518,15.095c0,15.196,12.362,27.559,27.559,27.559h76.772c30.796,0,60.947-10.419,85.172-29.385h19.881 c3.59,0,6.5-2.91,6.5-6.5S436.309,387.222,432.719,387.222z M13,155.335c0-20.531,10.399-39.376,27.167-50.416l0,100.846 C23.399,194.724,13,175.877,13,155.335z M324.375,388.272l-7.577,2.179c-1.825-3.917-4.543-7.334-7.892-9.993 c5.64-5.05,9.198-12.381,9.198-20.53c0-8.439-3.817-16.001-9.811-21.061c5.993-5.059,9.81-12.621,9.81-21.06 c0-2.164-0.252-4.282-0.738-6.342c0.551-0.443,1.086-0.904,1.604-1.385l16.658,57.826 C338.138,376.625,333.089,385.761,324.375,388.272z M395.485,155.341c0,33.293-27.086,60.379-60.38,60.379h-40.85V94.962h40.85 C368.399,94.962,395.485,122.048,395.485,155.341z M281.256,94.962v120.759h-19.397c-63.658,0-127.351,18.017-186.211,52.386 V42.568c58.86,34.369,122.552,52.387,186.211,52.387L281.256,94.962z M53.168,28.502c3.142,2.106,6.305,4.148,9.479,6.157v241.356 c-3.174,2.009-6.338,4.052-9.48,6.158L53.168,28.502z M242.042,229.331c6.603-0.402,13.211-0.61,19.817-0.61h10.693 c-1.637,3.129-2.568,6.683-2.568,10.453v8.959h-21.008L242.042,229.331z M232.965,261.132l37.019,0.002 c0,0,0.014,28.61,0.04,29.114l-37.058,0.002c-8.027,0-14.559-6.531-14.559-14.56C218.406,267.664,224.938,261.132,232.965,261.132z M226.092,303.251h47.782c5.042,8.737,14.476,14.635,25.267,14.635c2.032,0,4.016-0.21,5.932-0.608 c0.006,0.177,0.029,0.352,0.029,0.531c0,8.028-6.532,14.56-14.561,14.56l-64.45,0.001c-8.028,0-14.56-6.531-14.56-14.56 C211.532,309.782,218.063,303.251,226.092,303.251z M218.695,359.929c0-8.028,6.531-14.559,14.56-14.559h57.29 c8.027,0,14.559,6.531,14.559,14.559s-6.531,14.559-14.559,14.559h-57.29C225.227,374.488,218.695,367.957,218.695,359.929z M250.894,416.606c-8.027,0-14.559-6.531-14.559-14.559c0-8.028,6.531-14.56,14.559-14.56h40.912c8.028,0,14.56,6.531,14.56,14.56 c0,8.028-6.531,14.559-14.56,14.559H250.894z">
                                    </path>
                                </svg>
                                <span>Campaign/Offer</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                @if ($site_configuration->coupon == 1)
                                    <li><router-link :to="{ name: 'coupon' }">Coupon</router-link></li>
                                @endif
                                <li> <router-link :to="{ name: 'banner' }">Offer Banner </router-link> </li>
                                @if ($site_configuration->sms_on == 1)
                                    <li> <router-link :to="{ name: 'sms_marketing' }">SMS Marketing</router-link> </li>
                                    <li> <router-link :to="{ name: 'sms_campaign_list' }">Send SMS List</router-link>
                                    </li>
                                @endif
                                {{-- <li> <router-link :to="{ name: 'combo_products' }">Combo Product </router-link></li> --}}
                                <!-- <li> <a href="/admin/free/delivery">Free Delivery </a> </li>  -->
                            </ul>
                        </li>
                    @endif


                    @if ($admin->can('manage admin'))
                        <li class="treeview">
                            <a href="#">
                                <svg class="svg-icon" id="p-dash8" xmlns="http://www.w3.org/2000/svg"
                                    viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="9" cy="7" r="4"></circle>
                                </svg>
                                <span>Admin</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><router-link :to="{ name: 'adminAdd' }">Add</router-link></li>
                                <li><router-link :to="{ name: 'admin' }">Manage</router-link></li>
                            </ul>
                        </li>
                    @endif



                    @if ($admin->can('manage customers'))
                        <li class="treeview">
                            <a href="#">
                                <svg class="svg-icon" id="p-dash8" xmlns="http://www.w3.org/2000/svg"
                                    viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="9" cy="7" r="4"></circle>
                                    <path d="M23 21v-2a4 4 0 0 0-3-3.87"></path>
                                    <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                                </svg>
                                <span> Customer </span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><router-link :to="{ name: 'customer' }">Customers</router-link></li>
                                <li><router-link :to="{ name: 'contact_message' }">Message</router-link></li>

                            </ul>

                        </li>
                    @endif


                    @if ($admin->can('manage reports'))
                        <li class="treeview">
                            <a href="#">
                               <svg fill="none" stroke="currentColor" viewBox="0 0 24 24" class="w-5 h-5"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path></svg>
                                <span>Report</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><router-link :to="{ name: 'profit_report' }">Profit/Loss Report</router-link></li>
                                <li><router-link :to="{ name: 'product_stock_tracking' }">Product Stock and Profit
                                    </router-link></li>
                                <li><router-link :to="{ name: 'OrderReport' }">Order Report</router-link></li>
                                <li><router-link :to="{ name: 'OfficeSaleReport' }">Office Sale Report</router-link>
                                </li>
                                <li><router-link :to="{ name: 'OrderProfite' }">Order Profit</router-link>
                                <li>
                                <li><router-link :to="{ name: 'SaleProfite' }">Sale Profit</router-link></li>
                                <li><router-link :to="{ name: 'PurchaseReport' }">Purchase Report</router-link></li>
                                <li><router-link :to="{ name: 'SupplierReport' }">Supplier Report</router-link></li>
                                <li><router-link :to="{ name: 'productStock' }">Stock Report</router-link>
                                <li>
                            </ul>
                        </li>
                    @endif

                    {{-- @if ($admin->can('manage company'))
                        <li class="treeview">
                            <a href="#">
                                <svg stroke-width="2" stroke="currentColor" fill="currentColor"
                                    viewBox="0 0 256 256" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M224,118.31V200a8,8,0,0,1-8,8H40a8,8,0,0,1-8-8V118.31h0A191.14,191.14,0,0,0,128,144,191.08,191.08,0,0,0,224,118.31Z"
                                        opacity="0.2"></path>
                                    <path
                                        d="M104,112a8,8,0,0,1,8-8h32a8,8,0,0,1,0,16H112A8,8,0,0,1,104,112ZM232,72V200a16,16,0,0,1-16,16H40a16,16,0,0,1-16-16V72A16,16,0,0,1,40,56H80V48a24,24,0,0,1,24-24h48a24,24,0,0,1,24,24v8h40A16,16,0,0,1,232,72ZM96,56h64V48a8,8,0,0,0-8-8H104a8,8,0,0,0-8,8ZM40,72v41.62A184.07,184.07,0,0,0,128,136a184,184,0,0,0,88-22.39V72ZM216,200V131.63A200.25,200.25,0,0,1,128,152a200.19,200.19,0,0,1-88-20.36V200H216Z">
                                    </path>
                                </svg>
                                <span>Company Management</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>

                            <ul class="treeview-menu">

                                <li><router-link :to="{ name: 'loan' }">Manage Loan</router-link></li>
                                <li><router-link :to="{ name: 'investment' }">Manage Investment</router-link></li>
                                <li><router-link :to="{ name: 'company_assets' }">Manage Assets</router-link></li>
                                <li><router-link :to="{ name: 'directors' }">Directors </router-link></li>
                            </ul>
                        </li>
                    @endif --}}

                    @if ($admin->can('manage basic set up'))
                        <li class="treeview">
                            <a href="#">
                                <svg stroke="currentColor" fill="currentColor" stroke-width="0"
                                    viewBox="0 0 256 256" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M184,120v61.65a8,8,0,0,1-2.34,5.65l-34.35,34.35a8,8,0,0,1-13.57-4.53L128,176ZM136,72H74.35a8,8,0,0,0-5.65,2.34L34.35,108.69a8,8,0,0,0,4.53,13.57L80,128ZM40,216c37.65,0,50.69-19.69,54.56-28.18L68.18,161.44C59.69,165.31,40,178.35,40,216Z"
                                        opacity="0.2"></path>
                                    <path
                                        d="M223.85,47.12a16,16,0,0,0-15-15c-12.58-.75-44.73.4-71.41,27.07L132.69,64H74.36A15.91,15.91,0,0,0,63,68.68L28.7,103a16,16,0,0,0,9.07,27.16l38.47,5.37,44.21,44.21,5.37,38.49a15.94,15.94,0,0,0,10.78,12.92,16.11,16.11,0,0,0,5.1.83A15.91,15.91,0,0,0,153,227.3L187.32,193A15.91,15.91,0,0,0,192,181.64V123.31l4.77-4.77C223.45,91.86,224.6,59.71,223.85,47.12ZM74.36,80h42.33L77.16,119.52,40,114.34Zm74.41-9.45a76.65,76.65,0,0,1,59.11-22.47,76.46,76.46,0,0,1-22.42,59.16L128,164.68,91.32,128ZM176,181.64,141.67,216l-5.19-37.17L176,139.31Zm-74.16,9.5C97.34,201,82.29,224,40,224a8,8,0,0,1-8-8c0-42.29,23-57.34,32.86-61.85a8,8,0,0,1,6.64,14.56c-6.43,2.93-20.62,12.36-23.12,38.91,26.55-2.5,36-16.69,38.91-23.12a8,8,0,1,1,14.56,6.64Z">
                                    </path>
                                </svg>
                                <span>Landing Page</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><router-link :to="{ name: 'landing_page' }">Manage</router-link></li>
                            </ul>
                        </li>
                    @endif


                    @if ($site_configuration->show_reseller_panel == 1)
                        <li class="treeview">
                            <a href="#">
                                <svg xmlns="http://www.w3.org/2000/svg" stroke="currentColor" fill="currentColor"
                                    stroke-width="0" viewBox="0 0 24 24" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round" class="feather feather-wind">
                                    <path
                                        d="M9.59 4.59A2 2 0 1 1 11 8H2m10.59 11.41A2 2 0 1 0 14 16H2m15.73-8.27A2.5 2.5 0 1 1 19.5 12H2">
                                    </path>
                                </svg>
                                <span>Reselling</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>

                            <ul class="treeview-menu">
                                <li>
                                    <router-link :to="{ name: 'resellerHome' }"><i
                                            class="fa fa-arrow-circle-right"></i>Reseller
                                    </router-link>
                                </li>

                                <li>
                                    <router-link :to="{ name: 'withdraw_request_by_reseller' }"><i
                                            class="fa fa-arrow-circle-right"></i> Reseller Withdraw
                                        Request</router-link>
                                </li>

                            </ul>
                        </li>
                    @endif
                    @if ($site_configuration->show_merchant_panel == 1)
                        <li class="treeview">
                            <a href="#">
                                <i class="fa fa-user-secret"></i> <span>Merchant</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-left pull-right"></i>
                                </span>
                            </a>

                            <ul class="treeview-menu">
                                <li>
                                    <a href="/admin/merchant"><i class="fa fa-arrow-circle-right"></i> Merchant </a>
                                </li>
                                <li>
                                    <router-link :to="{ name: 'withdraw_request_by_merchant' }"><i
                                            class="fa fa-arrow-circle-right"></i> Merchant Withdraw Request
                                    </router-link>
                                </li>

                            </ul>
                        </li>
                    @endif

                </ul>
            </div>
        </div>

    </section>
    <!-- =========== Desktop Device End =========== -->


    <!-- =========== Mobile Device Start =========== -->
    <section class="sidebar sidebar_mobile_device">

        <!-- Sidebar user panel -->
        <div class="user-panel" style="border-bottom:1px solid rgba(106, 113, 133, 0.2)">

            <div class="pull-left image">
                @if ($admin != null && !empty($admin->image))
                    <img src="{{ asset('storage/' . $admin->image) }}" class="img-circle" alt="User Image">
                @else
                    <img src="{{ asset('admin/dist/img/user2-160x160.jpg') }}" class="img-circle" alt="User Image">
                @endif
            </div>
            <div class="pull-left info" style="top:1px;">
                @if ($admin != null)
                    <h4 style="color: #000000;">{{ explode(' ', trim($admin->name))[0] }}</h4>
                @endif
                <a style="color: #9FA8C1" href="#"><i class="fa fa-circle text-success"></i> Online</a>
                <br>
            </div>

            <div class="sidebar_search">
                <form action="#">
                    <input type="text" placeholder="search menu...." id="search_input" onkeyup="search()">
                </form>
            </div>

        </div>

        <div class="sidebar_content">
            <div class="main_menu">
                <ul class="sidebar-menu" id="sidebar-menu" data-widget="tree">

                    <li class="treeview">
                        <a href="#">
                            <svg stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"
                                xmlns="http://www.w3.org/2000/svg" fill="none">
                                <path
                                    d="M4 5a1 1 0 0 1 1-1h4a1 1 0 0 1 1 1v5a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V5ZM14 5a1 1 0 0 1 1-1h4a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1h-4a1 1 0 0 1-1-1V5ZM4 16a1 1 0 0 1 1-1h4a1 1 0 0 1 1 1v3a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1v-3ZM14 13a1 1 0 0 1 1-1h4a1 1 0 0 1 1 1v6a1 1 0 0 1-1 1h-4a1 1 0 0 1-1-1v-6Z" />
                            </svg>
                            <span>
                                <router-link :to="{ name: 'dashboard' }">Dashboard</router-link>
                            </span>
                        </a>
                    </li>



                    @if ($admin->can('manage Order'))
                        <li class="treeview order_m">
                            <a href="#">
                               <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-shopping-bag"><path d="M6 2L3 6v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2V6l-3-4z"></path><line x1="3" y1="6" x2="21" y2="6"></line><path d="M16 10a4 4 0 0 1-8 0"></path></svg>
                                <span>Orders</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="/admin/order/process/all/all"> Manage Order </a></li>
                                <li><a href="/admin/exchange/order/add">Add Exchange Order</a></li>
                                <li><a href="/admin/order/processing/report">Order Processing Report</a></li>
                                 <li><a href="/admin/order/source">Order Source</a></li>
                                <li><a href="/admin/comment">Order Processing Note</a></li>
                                <li><a href="/admin/courier">Courier</a></li>
                            </ul>
                        </li>
                    @endif

                    @if ($admin->can('manage Sale'))
                        <li class="treeview">
                            <a href="#">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="1.5"
                                    stroke="currentColor" fill="none" stroke-linecap="round"
                                    stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M7 10l5 -6l5 6"></path>
                                    <path d="M21 10l-2 8a2 2.5 0 0 1 -2 2h-10a2 2.5 0 0 1 -2 -2l-2 -8z"></path>
                                    <path d="M12 15m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                                </svg>
                                <span>Sale</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="/admin/sale/office">OfficeSale</a></li>
                                {{-- <li><a href="/admin/sale/company">Wholesale</a></li>
                                <li><a href="/admin/company">Wholeseller</a></li> --}}
                            </ul>
                        </li>
                    @endif


                    @if ($admin->can('Manage accounts'))
                        <li class="treeview">
                            <a href="#">
                                <svg stroke="currentColor" fill="currentColor" stroke-width="0"
                                    viewBox="0 0 256 256" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M224,64l-12.16,66.86A16,16,0,0,1,196.1,144H70.55L56,64Z" opacity="0.2">
                                    </path>
                                    <path
                                        d="M230.14,58.87A8,8,0,0,0,224,56H62.68L56.6,22.57A8,8,0,0,0,48.73,16H24a8,8,0,0,0,0,16h18L67.56,172.29a24,24,0,0,0,5.33,11.27,28,28,0,1,0,44.4,8.44h45.42A27.75,27.75,0,0,0,160,204a28,28,0,1,0,28-28H91.17a8,8,0,0,1-7.87-6.57L80.13,152h116a24,24,0,0,0,23.61-19.71l12.16-66.86A8,8,0,0,0,230.14,58.87ZM104,204a12,12,0,1,1-12-12A12,12,0,0,1,104,204Zm96,0a12,12,0,1,1-12-12A12,12,0,0,1,200,204Zm4-74.57A8,8,0,0,1,196.1,136H77.22L65.59,72H214.41Z">
                                    </path>
                                </svg>
                                <span>Accounts</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="/admin/credit">Income</a></li>
                                <li><a href="/admin/debit">Expense</a></li>
                                <li><a href="/admin/credit/due">Due</a></li>
                                {{-- <li><a href="/admin/all/balance">Mange Balance </a></li> --}}
                                <li><a href="/admin/balance">Balance</a></li>
                                <li><a href="/admin/found/transfer">Fund Transfer</a></li>
                                <li><a href="/admin/account/purpose">Account Purpose </a></li>
                                <li><a href="/admin/team/member">Employee Salary</a></li>
                                <li><a href="/admin/bill/statement">Bill Statements </a></li>
                            </ul>
                        </li>
                    @endif

                    @if ($admin->can('manage product'))
                        <li class="treeview">
                            <a href="#">
                                <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22"
                                    viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                    stroke-linecap="round" stroke-linejoin="round" class="feather feather-archive">
                                    <polyline points="21 8 21 21 3 21 3 8"></polyline>
                                    <rect x="1" y="3" width="22" height="5"></rect>
                                    <line x1="10" y1="12" x2="14" y2="12"></line>
                                </svg>
                                <span>Products</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="/admin/products/1">Manage Products</a></li>
                                <li><a href="/admin/attribute">Attribute/Size</a></li>
                                <li><a href="/admin/variant">Variant</a></li>

                                @if ($admin->can('manage purchase'))
                                    <li><a href="/admin/purchase">Products Purchase</a></li>
                                @endif

                                <li><a href="/admin/display/user/review/of/products">Products Review</a></li>

                                <li>
                                    <a href="/admin/product/view/report"> Product View Report </a>
                                </li>


                                @if ($site_configuration->template_id == 4)
                                    <li>
                                        <a href="/admin/author">Authors </a>
                                    </li>
                                    <li>
                                        <a href="/admin/publisher"> Publishers </a>
                                    </li>
                                @endif


                                @if ($site_configuration->template_id == 9)
                                    <li>
                                        <a href="/admin/country"> Country </a>
                                    </li>
                                    <li>
                                        <a href="/admin/skin"> Skin </a>
                                    </li>
                                @endif


                            </ul>
                        </li>
                    @endif


                    @if ($admin->can('manage supplier'))
                        <li class="treeview">
                            <a href="#">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                    stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round" class="feather feather-truck">
                                    <rect x="1" y="3" width="15" height="13"></rect>
                                    <polygon points="16 8 20 8 23 11 23 16 16 16 16 8"></polygon>
                                    <circle cx="5.5" cy="18.5" r="2.5"></circle>
                                    <circle cx="18.5" cy="18.5" r="2.5"></circle>
                                </svg>
                                <span>Product Supplier</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="/admin/Supplier/Add">Add</a></li>
                                <li><a href="/admin/supplier">Manage</a></li>
                            </ul>
                        </li>
                    @endif

                    @if ($admin->can('manage category'))
                        <li class="treeview">
                            <a href="#">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                    stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round">
                                    <rect x="9" y="9" width="13" height="13" rx="2" ry="2">
                                    </rect>
                                    <path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1"></path>
                                </svg>
                                <span>Category</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="/admin/category">Main Category</a></li>
                                <li><a href="/admin/subcategory">Sub Category</a></li>
                                <li><a href="/admin/subSubCategory">Sub Sub Category</a></li>
                            </ul>
                        </li>
                    @endif

                    @if ($admin->can('manage category'))
                        <li class="treeview">
                            <a href="#">
                                <svg stroke="currentColor" fill="currentColor" stroke-width="0"
                                    viewBox="0 0 256 256" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M64,64l40,120H24ZM200,76a44,44,0,1,0-44,44A44,44,0,0,0,200,76Zm-64,76v56h88V152Z"
                                        opacity="0.2"></path>
                                    <path
                                        d="M224,144H136a8,8,0,0,0-8,8v56a8,8,0,0,0,8,8h88a8,8,0,0,0,8-8V152A8,8,0,0,0,224,144Zm-8,56H144V160h72ZM71.59,61.47a8,8,0,0,0-15.18,0l-40,120A8,8,0,0,0,24,192h80a8,8,0,0,0,7.59-10.53ZM35.1,176,64,89.3,92.9,176ZM208,76a52,52,0,1,0-52,52A52.06,52.06,0,0,0,208,76Zm-88,0a36,36,0,1,1,36,36A36,36,0,0,1,120,76Z">
                                    </path>
                                </svg>
                                <span>Brand</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="/admin/brand">Brands</a></li>
                            </ul>
                        </li>
                    @endif

                    @if ($admin->can('manage slider'))
                        <li class="treeview">
                            <a href="#">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="1.5"
                                    stroke="currentColor" fill="none" stroke-linecap="round"
                                    stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path
                                        d="M4 6m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v3a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z">
                                    </path>
                                    <path d="M6 4l0 2"></path>
                                    <path d="M6 11l0 9"></path>
                                    <path
                                        d="M10 14m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v3a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z">
                                    </path>
                                    <path d="M12 4l0 10"></path>
                                    <path d="M12 19l0 1"></path>
                                    <path
                                        d="M16 5m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z">
                                    </path>
                                    <path d="M18 4l0 1"></path>
                                    <path d="M18 11l0 9"></path>
                                </svg>
                                <span>Slider</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="/admin/slider">Sliders</a></li>
                            </ul>
                        </li>
                    @endif



                    @if ($admin->can('manage basic set up'))
                        <li class="treeview">
                            <a href="#">
                                <svg stroke="currentColor" fill="currentColor" stroke-width="0"
                                    viewBox="0 0 256 256" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M64,64l40,120H24ZM200,76a44,44,0,1,0-44,44A44,44,0,0,0,200,76Zm-64,76v56h88V152Z"
                                        opacity="0.2"></path>
                                    <path
                                        d="M224,144H136a8,8,0,0,0-8,8v56a8,8,0,0,0,8,8h88a8,8,0,0,0,8-8V152A8,8,0,0,0,224,144Zm-8,56H144V160h72ZM71.59,61.47a8,8,0,0,0-15.18,0l-40,120A8,8,0,0,0,24,192h80a8,8,0,0,0,7.59-10.53ZM35.1,176,64,89.3,92.9,176ZM208,76a52,52,0,1,0-52,52A52.06,52.06,0,0,0,208,76Zm-88,0a36,36,0,1,1,36,36A36,36,0,0,1,120,76Z">
                                    </path>
                                </svg>
                                <span>Website Setup</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="/admin/header/setting">Header</a></li>
                                <li><a href="/admin/footer/info">Footer</a></li>
                                <li><a href="/admin/theme/setting">Theme Color</a></li>
                                <li><a href="/admin/page/info/lists">Pages</a></li>
                            </ul>
                        </li>
                        {{-- <li class="treeview">
                            <a href="#">
                                <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 256 256" xmlns="http://www.w3.org/2000/svg"><path d="M64,64l40,120H24ZM200,76a44,44,0,1,0-44,44A44,44,0,0,0,200,76Zm-64,76v56h88V152Z" opacity="0.2"></path><path d="M224,144H136a8,8,0,0,0-8,8v56a8,8,0,0,0,8,8h88a8,8,0,0,0,8-8V152A8,8,0,0,0,224,144Zm-8,56H144V160h72ZM71.59,61.47a8,8,0,0,0-15.18,0l-40,120A8,8,0,0,0,24,192h80a8,8,0,0,0,7.59-10.53ZM35.1,176,64,89.3,92.9,176ZM208,76a52,52,0,1,0-52,52A52.06,52.06,0,0,0,208,76Zm-88,0a36,36,0,1,1,36,36A36,36,0,0,1,120,76Z"></path></svg>
                                <span>Site Configuration</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="/admin/site/configuration">Configuration</a></li>
                            </ul>
                        </li> --}}
                        <li class="treeview">
                            <a href="#">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2"
                                    stroke="currentColor" fill="none">
                                    <path
                                        d="M10.325 4.317c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.756 .426 1.756 2.924 0 3.35a1.724 1.724 0 0 0 -1.066 2.573c.94 1.543 -.826 3.31 -2.37 2.37a1.724 1.724 0 0 0 -2.572 1.065c-.426 1.756 -2.924 1.756 -3.35 0a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065z">
                                    </path>
                                    <path d="M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0"></path>
                                </svg>
                                <span>Setting & Configuration</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="/admin/marketing/setting">Marketing</a></li>
                                {{-- <li><a href="/admin/sms/service">SMS API</a></li> --}}
                                <li><a href="/admin/courier/api">Courier API</a></li>
                                <li><a href="/admin/general/setting">Invoice Address</a></li>
                                <li><a href="/admin/delivery/charge">Delivery Charge</a></li>
                                <li><a href="/admin/social/login">Social Login</a></li>
                                {{-- <li><a href="/admin/payment/setup">Payment setup</a></li> --}}
                                <li><a href="/admin/city">City</a></li>
                                <li><a href="/admin/sub/city">Sub City </a></li>
                               

                            </ul>
                        </li>


                        <li class="treeview">
                            <a href="#">
                                <svg stroke-width="1.5" stroke="currentColor" fill="currentColor"
                                    xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="-43.92 -43.92 527.06 527.06"
                                    xml:space="preserve" transform="rotate(0)matrix(-1, 0, 0, 1, 0, 0)">
                                    <path
                                        d="M432.719,387.222h-22.153c-1.49,0-2.936,0.512-4.094,1.451c-22.218,18.013-50.205,27.934-78.806,27.934H315.19 c2.443-3.909,3.934-8.47,4.144-13.358l8.637-2.484c15.605-4.497,24.643-20.851,20.146-36.455l-9.784-33.965 c7.844,5.077,17.178,8.039,27.197,8.039c3.59,0,6.5-2.91,6.5-6.5s-2.91-6.5-6.5-6.5c-20.513,0-37.201-16.688-37.201-37.201 l-0.029-35.912c0-3.59-2.91-6.5-6.5-6.5s-6.5,2.91-6.5,6.5v36.457c0,8.91-7.249,16.159-16.159,16.159s-16.158-7.249-16.158-16.159 v-49.554c0-5.311,4.321-9.632,9.632-9.632h49.948c19.094,0,37.101,9.289,48.162,24.842l0.118,0.166 c8.998,12.65,23.638,20.203,39.161,20.203c3.59,0,6.5-2.91,6.5-6.5s-2.91-6.5-6.5-6.5c-11.324,0-22.004-5.509-28.563-14.731 l-0.118-0.166c-8.471-11.91-20.276-20.806-33.65-25.783c24.162-12.021,40.811-36.962,40.811-65.73 c0-40.461-32.918-73.379-73.38-73.379l-73.247-0.007c-72.942,0-146.052-24.599-211.422-71.138 c-1.981-1.411-4.585-1.598-6.748-0.482s-3.521,3.344-3.521,5.777l0,73.802C15.633,102.363,0,127.582,0,155.348 c0,27.754,15.634,52.973,40.168,65.42l0,73.795c0,2.433,1.358,4.662,3.521,5.777c0.938,0.484,1.96,0.723,2.978,0.723 c1.328,0,2.649-0.406,3.771-1.205c55.427-39.46,116.417-63.139,178.152-69.432l6.53,17.706h-2.155 c-15.196,0-27.559,12.363-27.559,27.559c0,6.995,2.624,13.386,6.934,18.251c-8.245,4.769-13.808,13.678-13.808,23.868 c0,10.269,5.65,19.238,14.001,23.979c-4.252,4.851-6.838,11.197-6.838,18.14c0,13.348,9.539,24.506,22.158,27.024 c-2.852,4.339-4.518,9.525-4.518,15.095c0,15.196,12.362,27.559,27.559,27.559h76.772c30.796,0,60.947-10.419,85.172-29.385h19.881 c3.59,0,6.5-2.91,6.5-6.5S436.309,387.222,432.719,387.222z M13,155.335c0-20.531,10.399-39.376,27.167-50.416l0,100.846 C23.399,194.724,13,175.877,13,155.335z M324.375,388.272l-7.577,2.179c-1.825-3.917-4.543-7.334-7.892-9.993 c5.64-5.05,9.198-12.381,9.198-20.53c0-8.439-3.817-16.001-9.811-21.061c5.993-5.059,9.81-12.621,9.81-21.06 c0-2.164-0.252-4.282-0.738-6.342c0.551-0.443,1.086-0.904,1.604-1.385l16.658,57.826 C338.138,376.625,333.089,385.761,324.375,388.272z M395.485,155.341c0,33.293-27.086,60.379-60.38,60.379h-40.85V94.962h40.85 C368.399,94.962,395.485,122.048,395.485,155.341z M281.256,94.962v120.759h-19.397c-63.658,0-127.351,18.017-186.211,52.386 V42.568c58.86,34.369,122.552,52.387,186.211,52.387L281.256,94.962z M53.168,28.502c3.142,2.106,6.305,4.148,9.479,6.157v241.356 c-3.174,2.009-6.338,4.052-9.48,6.158L53.168,28.502z M242.042,229.331c6.603-0.402,13.211-0.61,19.817-0.61h10.693 c-1.637,3.129-2.568,6.683-2.568,10.453v8.959h-21.008L242.042,229.331z M232.965,261.132l37.019,0.002 c0,0,0.014,28.61,0.04,29.114l-37.058,0.002c-8.027,0-14.559-6.531-14.559-14.56C218.406,267.664,224.938,261.132,232.965,261.132z M226.092,303.251h47.782c5.042,8.737,14.476,14.635,25.267,14.635c2.032,0,4.016-0.21,5.932-0.608 c0.006,0.177,0.029,0.352,0.029,0.531c0,8.028-6.532,14.56-14.561,14.56l-64.45,0.001c-8.028,0-14.56-6.531-14.56-14.56 C211.532,309.782,218.063,303.251,226.092,303.251z M218.695,359.929c0-8.028,6.531-14.559,14.56-14.559h57.29 c8.027,0,14.559,6.531,14.559,14.559s-6.531,14.559-14.559,14.559h-57.29C225.227,374.488,218.695,367.957,218.695,359.929z M250.894,416.606c-8.027,0-14.559-6.531-14.559-14.559c0-8.028,6.531-14.56,14.559-14.56h40.912c8.028,0,14.56,6.531,14.56,14.56 c0,8.028-6.531,14.559-14.56,14.559H250.894z">
                                    </path>
                                </svg>
                                <span>Campaign/Offer</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                @if ($site_configuration->coupon == 1)
                                    <li><router-link :to="{ name: 'coupon' }">Coupon</router-link></li>
                                @endif
                                <li> <a href="/admin/banner">Offer Banner </a> </li>
                                {{-- <li> <a href="/admin/combo/products">Combo Product </a> </li>
                                <li> <a href="/admin/free/delivery">Free Delivery </a> </li> --}}
                            </ul>
                        </li>
                    @endif


                    @if ($admin->can('manage admin'))
                        <li class="treeview">
                            <a href="#">
                                <svg class="svg-icon" id="p-dash8" xmlns="http://www.w3.org/2000/svg"
                                    viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="9" cy="7" r="4"></circle>
                                </svg>
                                <span>Admin</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="/admin/addAdmin">Add</a></li>
                                <li><a href="/admin/listAdmin">Manage</a></li>
                            </ul>
                        </li>
                    @endif



                    @if ($admin->can('manage customers'))
                        <li class="treeview">
                            <a href="#">
                                <svg class="svg-icon" id="p-dash8" xmlns="http://www.w3.org/2000/svg"
                                    viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="9" cy="7" r="4"></circle>
                                    <path d="M23 21v-2a4 4 0 0 0-3-3.87"></path>
                                    <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                                </svg>
                                <span> Customer </span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="/admin/customer/list">Customers</a></li>
                                <li><a href="/admin/contact/message">Message</a></li>
                            </ul>

                        </li>
                    @endif


                    @if ($admin->can('manage reports'))
                        <li class="treeview">
                            <a href="#">
                                <svg xmlns="http://www.w3.org/2000/svg"
                                    class="icon-tabler icon-tabler-files iconClass" width="20px" height="20px"
                                    viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M15 3v4a1 1 0 0 0 1 1h4"></path>
                                    <path d="M18 17h-7a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h4l5 5v7a2 2 0 0 1 -2 2z">
                                    </path>
                                    <path d="M16 17v2a2 2 0 0 1 -2 2h-7a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"></path>
                                </svg>
                                <span>Report</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="/admin/profit/report">Profit/Loss Report</a></li>
                                <li><a href="/admin/product/stock/report">Product Stock and Profit </a></li>
                                <li><a href="/admin/order/report">Order Report</a></li>
                                <li><a href="/admin/office/sale/report">Office Sale Report</a></li>
                                <li><a href="/admin/order/profit/report">Order Profit</a>
                                <li>
                                <li><a href="/admin/sale/profit/report">Sale Profit</a></li>
                                <li><a href="/admin/purchase/report">Purchase Report</a></li>
                                <li><a href="/admin/supplier/report">Supplier Report</a></li>
                                <li><a href="/admin/report/product/stock">Stock Report</a>
                                <li>
                            </ul>
                        </li>
                    @endif

                    {{-- @if ($admin->can('manage company'))
                        <li class="treeview">
                            <a href="#">
                                <svg stroke-width="2" stroke="currentColor" fill="currentColor"
                                    viewBox="0 0 256 256" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M224,118.31V200a8,8,0,0,1-8,8H40a8,8,0,0,1-8-8V118.31h0A191.14,191.14,0,0,0,128,144,191.08,191.08,0,0,0,224,118.31Z"
                                        opacity="0.2"></path>
                                    <path
                                        d="M104,112a8,8,0,0,1,8-8h32a8,8,0,0,1,0,16H112A8,8,0,0,1,104,112ZM232,72V200a16,16,0,0,1-16,16H40a16,16,0,0,1-16-16V72A16,16,0,0,1,40,56H80V48a24,24,0,0,1,24-24h48a24,24,0,0,1,24,24v8h40A16,16,0,0,1,232,72ZM96,56h64V48a8,8,0,0,0-8-8H104a8,8,0,0,0-8,8ZM40,72v41.62A184.07,184.07,0,0,0,128,136a184,184,0,0,0,88-22.39V72ZM216,200V131.63A200.25,200.25,0,0,1,128,152a200.19,200.19,0,0,1-88-20.36V200H216Z">
                                    </path>
                                </svg>
                                <span>Company Management</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>

                            <ul class="treeview-menu">

                                <li><a href="/admin/loan/manage">Manage Loan</a></li>
                                <li><a href="/admin/company/investment">Manage Investment</a></li>
                                <li><a href="/admin/company/assets">Manage Assets</a></li>
                                <li><a href="/admin/director">Directors </a></li>
                            </ul>
                        </li>
                    @endif --}}

                    @if ($admin->can('manage basic set up'))
                        <li class="treeview">
                            <a href="#">
                                <svg stroke-width="2" stroke="currentColor" fill="currentColor"
                                    viewBox="0 0 256 256" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M184,120v61.65a8,8,0,0,1-2.34,5.65l-34.35,34.35a8,8,0,0,1-13.57-4.53L128,176ZM136,72H74.35a8,8,0,0,0-5.65,2.34L34.35,108.69a8,8,0,0,0,4.53,13.57L80,128ZM40,216c37.65,0,50.69-19.69,54.56-28.18L68.18,161.44C59.69,165.31,40,178.35,40,216Z"
                                        opacity="0.2"></path>
                                    <path
                                        d="M223.85,47.12a16,16,0,0,0-15-15c-12.58-.75-44.73.4-71.41,27.07L132.69,64H74.36A15.91,15.91,0,0,0,63,68.68L28.7,103a16,16,0,0,0,9.07,27.16l38.47,5.37,44.21,44.21,5.37,38.49a15.94,15.94,0,0,0,10.78,12.92,16.11,16.11,0,0,0,5.1.83A15.91,15.91,0,0,0,153,227.3L187.32,193A15.91,15.91,0,0,0,192,181.64V123.31l4.77-4.77C223.45,91.86,224.6,59.71,223.85,47.12ZM74.36,80h42.33L77.16,119.52,40,114.34Zm74.41-9.45a76.65,76.65,0,0,1,59.11-22.47,76.46,76.46,0,0,1-22.42,59.16L128,164.68,91.32,128ZM176,181.64,141.67,216l-5.19-37.17L176,139.31Zm-74.16,9.5C97.34,201,82.29,224,40,224a8,8,0,0,1-8-8c0-42.29,23-57.34,32.86-61.85a8,8,0,0,1,6.64,14.56c-6.43,2.93-20.62,12.36-23.12,38.91,26.55-2.5,36-16.69,38.91-23.12a8,8,0,1,1,14.56,6.64Z">
                                    </path>
                                </svg>
                                <span>Landing Page</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>
                            <ul class="treeview-menu">
                                <li><a href="/admin/landing/page">Manage </a></li>
                            </ul>
                        </li>
                    @endif



                    @if ($site_configuration->show_reseller_panel == 1)
                        <li class="treeview">
                            <a href="#">
                                <svg stroke="currentColor" fill="currentColor" stroke-width="0"
                                    viewBox="0 0 256 256" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M184,120v61.65a8,8,0,0,1-2.34,5.65l-34.35,34.35a8,8,0,0,1-13.57-4.53L128,176ZM136,72H74.35a8,8,0,0,0-5.65,2.34L34.35,108.69a8,8,0,0,0,4.53,13.57L80,128ZM40,216c37.65,0,50.69-19.69,54.56-28.18L68.18,161.44C59.69,165.31,40,178.35,40,216Z"
                                        opacity="0.2"></path>
                                    <path
                                        d="M223.85,47.12a16,16,0,0,0-15-15c-12.58-.75-44.73.4-71.41,27.07L132.69,64H74.36A15.91,15.91,0,0,0,63,68.68L28.7,103a16,16,0,0,0,9.07,27.16l38.47,5.37,44.21,44.21,5.37,38.49a15.94,15.94,0,0,0,10.78,12.92,16.11,16.11,0,0,0,5.1.83A15.91,15.91,0,0,0,153,227.3L187.32,193A15.91,15.91,0,0,0,192,181.64V123.31l4.77-4.77C223.45,91.86,224.6,59.71,223.85,47.12ZM74.36,80h42.33L77.16,119.52,40,114.34Zm74.41-9.45a76.65,76.65,0,0,1,59.11-22.47,76.46,76.46,0,0,1-22.42,59.16L128,164.68,91.32,128ZM176,181.64,141.67,216l-5.19-37.17L176,139.31Zm-74.16,9.5C97.34,201,82.29,224,40,224a8,8,0,0,1-8-8c0-42.29,23-57.34,32.86-61.85a8,8,0,0,1,6.64,14.56c-6.43,2.93-20.62,12.36-23.12,38.91,26.55-2.5,36-16.69,38.91-23.12a8,8,0,1,1,14.56,6.64Z">
                                    </path>
                                </svg>
                                <span>Reselling</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-down pull-right"></i>
                                </span>
                            </a>

                            <ul class="treeview-menu">
                                <li>
                                    <a href="/admin/manage/reseller">Reseller
                                    </a>
                                </li>

                                <li>
                                    <a href="/admin/withdraw/request/by/resellers">Reseller Withdraw Request</a>
                                </li>

                            </ul>
                        </li>
                    @endif
                    @if ($site_configuration->show_merchant_panel == 1)
                        <li class="treeview">
                            <a href="#">
                                <i class="fa fa-user-secret"></i> <span>Merchant</span>
                                <span class="pull-right-container">
                                    <i class="fa fa-angle-left pull-right"></i>
                                </span>
                            </a>

                            <ul class="treeview-menu">
                                <li>
                                    <a href="/admin/merchant"><i class="fa fa-arrow-circle-right"></i> Merchant </a>
                                </li>
                                <li>
                                    <router-link :to="{ name: 'withdraw_request_by_merchant' }"><i
                                            class="fa fa-arrow-circle-right"></i> Merchant Withdraw Request
                                    </router-link>
                                </li>

                            </ul>
                        </li>
                    @endif
                </ul>
            </div>
        </div>

    </section>
    <!-- =========== Mobile Device End =========== -->



</aside>
