<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css"
        integrity="sha384-Vkoo8x4CGsO3+Hhxv8T/Q5PaXtkKtu6ug5TOeNV6gBiFeWPGFN9MuhOf23Q9Ifjh" crossorigin="anonymous">
    <link href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
    <title>
        Income Records
    </title>


</head>

<body>
    <div class="btn-pr">
        <button class="btn btn-success text-center print-button" onclick="allPrint()" id="print"><i
                class="fa fa-print"></i></button>
    </div>
    <div class="container page-break">
        <div class="row justify-content-center break">
            <div class="col-lg-6 text-center m-auto">
                <img class="inv_logo"
                    src="https://advance.mohasagorit.solutions/public/storage/images/general_setting/KXOpEuKhrnavFqaJctKilSOwpc9aT6tnKEP9OHhR.png"
                    alt="logo" width="240px">
                <p class="logo my-3"> mohasagorit.solutions </p>
                <p> </p>
                <p>House-08(5th floor), Block-A, Road-07, Mirpur-10, Dhaka-1216 (Opposite of Indoor Stadium) Metro
                    pillar No 231</p>
                <p></p>
                <p class="current_date">
                    <span>Date:</span>
                    <span>28/09/2025</span>
                </p>
            </div>
        </div>
        <div class="row justify-content-center" style="margin-top: 6px;">
            <div class="col-lg-12">

                <table class="table table-bordered">
                    <thead>


                        <tr style="text-align: center;">
                            <th>SL No.</th>
                            <th>Date</th>
                            <th>Invoice </th>
                            <th>Purpose</th>
                            <th>Credit In</th>
                            <th>Amount</th>
                            <th>Comment</th>
                            <th>Inserted By</th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach ($credits as $key => $credit)
                            <tr style="text-align: center;">
                                <td>{{ $key + 1 }}</td>
                                <td>{{ $credit->date }}</td>
                                <td>CR-{{ $credit->id }}</td>
                                <td>{{ $credit->purpose ?? '' }}</td>
                                <td>{{ $credit->balance ? $credit->balance->name : '' }}</td>
                                <td>{{ $credit->amount }}</td>
                                <td>
                                    @if ($credit->comment && strlen($credit->comment) > 50)
                                        {{ substr($credit->comment, 0, 50) . '...' }}
                                    @else
                                        {{ $credit->comment }}
                                    @endif
                                </td>
                                <td>{{ $credit->admin->name ?? '' }}</td>
                            </tr>
                        @endforeach

                        @php
                            $total = App\Models\Credit::sum('amount');
                        @endphp

                        <tr style="text-align: center;">
                            <td colspan="5"></td>

                            <td> = {{ $total }} </td>
                            </td>
                        </tr>

                    </tbody>
                </table>


            </div>
        </div>

    </div>

    <style>
        .pull-right.moha_add_inv {
            text-align: right;
            margin-right: 120px !important;
            margin-top: 20px;
        }



        body {
            background: #ddd;
        }

        .print {
            background: #fff;
            padding: 28px;
            display: block;
        }

        .page-break {
            page-break-after: always;
            background-color: #fff;
            padding-bottom: 50px;
            padding-top: 50px;
            margin-bottom: 20px;
            width: 70%;
        }

        .col-lg-4 {
            text-align: center;
            width: 35% !important;
            margin: 0;
            padding: 0;
            margin-left: 20px;
        }

        .col-lg-6 {
            text-align: center;
            width: 60% !important;
            margin: 0;
            padding: 0;
        }

        @media print {
            #print {
                display: none;
            }
        }

        .btn-pr {
            text-align: right;
            display: block;
            position: fixed;
            right: 0;
            top: 280px;
        }

        .btn-pr button {
            height: 50px;
        }
    </style>

    <script>
        function allPrint() {
            window.print();
        };

        window.addEventListener('DOMContentLoaded', (event) => {
            window.print();
            window.localStorage();
        });
    </script>

</body>

</html>
