<!DOCTYPE html>
<html>

<head>
    <title>Low Stock Report</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            margin: 0;
            padding: 0;
        }

        .stock_report_header {
            text-align: center;
            padding: 20px 0;
            border-bottom: 1px solid #ccc;
        }

        .stock_report_header {
            text-align: center;
        }

        .stock_report_header img {
            max-height: 55px;
            margin-bottom: 2px;
        }

        .stock_report_header span {
            display: block;
            margin-top: 2px;
            font-size: 14px;
        }

        h2 {
            text-align: center;
            margin-top: 20px;
            font-weight: 500;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            border: 1px solid #dddddd;
            padding: 8px;
            text-align: left;
        }

        th {
            background-color: #F4F6F9;
            font-weight: 500;
        }

        .low-stock {
            background-color: #ffffff;
        }

        span.product_variant_with_stock_stock {
    display: inline-block !important;
    width: 100px !important;
}
span.product_variant_with_stock_name {
    display: inline-block !important;
    width: 100px !important;
}

        @media print {
            * {
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
                color-adjust: exact !important;
            }
        }

        .table thead th {
            background-color: #F4F6F9;
        }

        th {
            background-color: #F4F6F9;

        }

        .product_manage_price ul {
            margin: 0;
            padding: 0;
        }

        .product_manage_price ul li {
            list-style: none;
            margin-bottom: 10px;
        }

        .product_manage_price ul li:last-child {
            margin-bottom: 0px;
        }

        .product_manage_price ul li p {
            color: #5D6A83;
            font-size: 15px;
        }

        .product_manage_price ul li p span {
            color: #5D6A83;
            font-size: 15px;
        }

        .product_variant_with_stock {
            display: flex;
            justify-content: space-evenly;
            align-items: center;
            gap: 10px;
        }
    </style>
</head>

<body>

    <div class="stock_report_header">
        <img src="{{ public_path('storage/' . $setting->logo) }}" alt="logo">
        <span>{{ $setting->title }}</span>
        <span>{!! $setting->invoice_address_details !!}</span>
    </div>

    <h2 style="text-align: center;">Low Stock Report (Stock < 5)</h2>
            <table>
                <thead>
                    <tr>
                        <th width = 15%;>Image</th>
                        <th width = 15%;>Product Code</th>
                        <th width = 30%;>Product Name</th>
                        <th width = 40%;>Stock</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($products as $product)
                        <tr class="{{ $product->stock <= 5 ? 'low-stock' : '' }}">
                            <td>
                                @if ($product->thumbnail_img)
                                    <img src="{{ public_path('storage/' . $product->thumbnail_img) }}"
                                        style="max-width: 80px; height: auto;">
                                @else
                                    No Image
                                @endif
                            </td>
                            <td>{{ $product->product_code }}</td>
                            <td>{{ $product->name }}</td>
                            @if ($site_Config->variant_wise_stock == 1)
                                <td>
                                    <div class="product_manage_price" v-else>
                                        <ul>
                                            @foreach ($product->productVariant ?? [] as $variant)
                                                <li>
                                                    <div class=" product_variant_with_stock">
                                                            <span class="product_variant_with_stock_name">
                                                                {{ $variant->variant->attribute->name ?? '' }} :
                                                                <strong>{{ $variant->variant->name ?? '' }}</strong>
                                                            </span>
                                                            <span class="product_variant_with_stock_stock"> stock <strong>{{ $variant->stock ?? '' }}</strong>
                                                            </span>
                                                    </div>
                                                </li>
                                            @endforeach

                                        </ul>
                                    </div>
                                </td>
                            @else
                                <td>{{ $product->stock }}</td>
                            @endif
                        </tr>
                    @endforeach
                </tbody>
            </table>
</body>

</html>
