<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap CSS -->
    {{-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-beta1/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-giJF6kkoqNQ00vy+HMDP7azOuL0xtbfIcaT9wjKHr8RbDVddVHyTfAAsrekwKmP1" crossorigin="anonymous"> --}}

    <title>order pick list </title>
    <style>
        body {
            margin-top: 20px;
            background-color: #F3F4F6;
            margin-bottom: 20px;
            width: 100%;
            height: 100%;
            margin: 0;
            padding: 0;
            font-family: ;
            font-weight: normal;
            font-style: normal;
            font-size: 16px;
            line-height: 26px;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
        }

        .order_pick_container {
            background-color: #fff;
            padding: 32px;
            border-radius: 16px;
        }

        * {
            margin: 0;
            padding: 0;
        }

        h1,
        h2,
        h3,
        h4,
        h5,
        h6,
        p {
            margin: 0px;
        }




        .address {
            line-height: 0.4;
            text-align: center;
        }

        .logo {
            font-size: 24px;
            font-weight: bolder;
            line-height: 30px;
            margin-bottom: 12px;
        }

        .p-h {
            text-align: center;
            text-transform: uppercase;
            font-weight: bold;
            font-size: 16px;
        }

        .address p {
            color: #4B5563;
            font-weight: 400;
            margin-bottom: 16px;
        }

        .order_invoice {
            display: flex;
            gap: 10px;
            text-align: center;
            align-items: center;
            width: 100%;
            justify-content: center;
            margin-top: 8px;
        }

        .order_invoice span {
            font-weight: 600;
            color: #4B5563;
        }

        .print_heading {
            background-color: #F9FAFB;
            border-radius: 0.25rem;
            padding: 12px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin: 16px 0px;
        }

        .download_pdf_button {
            display: flex;
            align-items: center;
            gap: 6px;
            padding: 10px 10px;
            background-color: #1fc4ac;
            color: #ffffff;
            border-radius: 8px;
            cursor: pointer;
            transition: background-color 0.3s ease;
            border: none;
        }

        .download_pdf_button:hover {
            background-color: rgba(31, 196, 172, 0.9);
        }

        .download_pdf_button svg {
            width: 16px;
            height: 16px;
        }

        .table-container {
            max-width: 100%;
            margin: 20px auto;
            background-color: #ffffff;
            border-radius: 10px;
            overflow: hidden;
            font-family: 'Inter', sans-serif;
            border: 1px solid #e5e7eb;
        }

        .product-table {
            width: 100%;
            border-collapse: collapse;
        }

        .product-table th,
        .product-table td {
            padding: 12px 16px;
            text-align: left;
            font-size: 14px;
            color: #4b5563;
            border-bottom: 1px solid #e5e7eb;
        }

        .product-table th {
            background-color: #f9fafb;
            font-weight: 600;
        }

        .product-table td img {
            width: 50px;
            height: 50px;
            border-radius: 8px;
            object-fit: cover;
            margin-right: 10px;
        }

        .product-info {
            display: flex;
            align-items: center;
        }

        .variant {
            display: inline-block;
            padding: 3px 10px;
            background-color: #e0e7ff;
            color: #4f46e5;
            border-radius: 9999px;
            font-size: 12px;
            font-weight: 500;
        }

        .quantity {
            font-weight: 600;
            color: #111827;
        }

        .total-items {
            padding: 12px 16px;
            font-weight: 600;
            text-align: right;
            background-color: #f9fafb;
            font-size: 14px;
        }

        .product-info span {
            line-height: 20px !important;
        }

        /* Optional: scroll bar styling for mobile */
        .table-container::-webkit-scrollbar {
            height: 6px;
        }

        .table-container::-webkit-scrollbar-thumb {
            background-color: #1fc4ac;
            border-radius: 3px;
        }

        .product-table {
            width: 100%;
            min-width: 600px;
            border-collapse: collapse;
        }



        @media (max-width: 768px) {
            .order_pick_container {
                padding: 16px;
                border-radius: 8px;
            }

            .logo {
                font-size: 20px;
            }

            .p-h {
                font-size: 14px;
            }

            .product-table th,
            .product-table td {
                padding: 8px 10px;
                font-size: 13px;
            }

            .variant {
                padding: 2px 6px;
                font-size: 11px;
            }

            .quantity {
                font-size: 13px;
            }

            .download_pdf_button {
                padding: 8px 8px;
                font-size: 13px;
            }

            .print_heading {
                flex-direction: column;
                gap: 10px;
            }

            .product-info span {
                max-width: 250px;
            }

            .table-container {
                overflow-x: auto;
                /* ensure scroll works on mobile */
            }

            .product-table th,
            .product-table td {
                padding: 8px 10px;
                font-size: 13px;
            }
        }
    </style>
</head>

<body>

    <div class="container">
        <div class="order_pick_container">
            <div class="row">
                <div class="address">
                    <h3 class="logo"> {{ $company_info->title }} </h3>
                    <p class="address_line">
                        {!! $company_info->invoice_address_details !!}
                    </p>
                </div>

                <div class="col-lg-12">
                    <div class="order_invoice">
                        <p>Orders Invoice :</p>
                        <span>
                            @foreach ($order_invoices as $item)
                                {{ $item->invoice_no }} ,
                            @endforeach
                        </span>
                    </div>

                    <div class="print_heading">
                        <p> Printed: @php
                            echo date('l jS \of F Y h:i:s A') . '<br>';
                        @endphp</p>

                        {{-- <button class="download_pdf_button">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round"
                                class="icon icon-tabler icons-tabler-outline icon-tabler-download">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                <path d="M4 17v2a2 2 0 0 0 2 2h12a2 2 0 0 0 2 -2v-2" />
                                <path d="M7 11l5 5l5 -5" />
                                <path d="M12 4l0 12" />
                            </svg>
                            <span>Download PDF</span>
                        </button> --}}
                    </div>
                </div>

                <div class="col-lg-12">
                    <p class="p-h">order picklist</p>

                    <div class="table-container">
                        <table class="product-table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Code</th>
                                    <th>Product</th>
                                    <th>Variants</th>
                                    <th>Quantity</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php $total_qty = 0; @endphp
                                @foreach ($orders as $k => $item)
                                    @php $total_qty += $item->total_qty; @endphp
                                    <tr>
                                        <td>{{ $k + 1 }}</td>
                                        <td>{{ $item->product_code }}</td>
                                        <td>
                                            <div class="product-info">
                                                <img src="{{ asset('storage/' . $item->thumbnail_img) }}"
                                                    alt="{{ $item->name }}">
                                                <span>{{ $item->name }}</span>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="variant">{{ $item->variant_name }}</span>
                                        </td>
                                        <td class="quantity">{{ $item->total_qty }}</td>
                                    </tr>
                                @endforeach
                                <tr>
                                    <td colspan="4" class="total-items text-end">Total:</td>
                                    <td class="quantity">{{ $total_qty }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                </div>

            </div>
        </div>
    </div>

</body>

</html>
