<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- caption -->
    <title>order invoice</title>
    <!-- style.css link -->
    <link rel="stylesheet" href="{{ asset('admin/css/style.css') }}">
    <!--bootstrap link -->
    {{-- <link rel="stylesheet" href="bootstrap.min.css">
    <link rel="stylesheet" href="bootstrap.bundle.min.js">
      <!-- font awesome link -->
      <link rel="stylesheet" href="font-awesome-4.7.0/css/font-awesome.min.css"> --}}
    @include('admin.partials.css')
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: verdana;
        }

        .full {
            width: 562px;
            margin: 0 auto;
        }


        /*====first area start====*/
        .first-area {
            border-bottom: 2px solid #ddd;
        }

        /*logo and address start*/

        .first-area-l-and-a {
            display: flex;
            justify-content: end;
        }

        .first-area-logo img {
            width: 305px;
            height: 40px;
        }

        .first-area-l-and-a p {
            color: #000;
            line-height: 0.5;
            font-size: 14px;
        }

        .first-area-logo-and-address-border-bottom {
            border: 2px solid #DDDDDD;
            width: 252px;
            border-radius: 5px;
        }

        /*logo and address end*/



        /*first area invoice start*/
        .first-area-invoice {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 50px;
        }

        .first-area-invoice-left {
            line-height: 0.8;
        }

        .first-area-invoice-mobail-no {
            display: flex;
            align-items: center;
            gap: 15px;
            font-size: 14px;
        }

        .first-area-invoice-bill-and-client p {
            font-size: 14px;
        }

        .address-text p {
            font-size: 14px;
        }

        .first-area-invoice-address {
            display: flex;
            align-items: center;
            gap: 5px;
        }

        .full-address p {
            font-size: 12px;
        }

        .first-area-invoice-right {

        }

        .invoice-time-and-no {
            line-height: 0.5;
            margin-top: 75px;
        }

        .invoice-no p {
            font-size: 13px;
        }

        /*first area invoice end*/

        /*=====first area end=====*/

        /*====middle area start====*/
        .invoice_table_bg_th tbody tr th {
            background-color: #000000;
            color: #ffffff;
        }

        .middle-area {
            margin: 30px 0px;
        }

        /*====middle area start====*/

        /*====last area start====*/
        .last-area {}

        .last-area-term-and-prepare {
            overflow: hidden;
        }

        .head-and-text {
            text-align: justify;
            width: 200px;
            float: left;
        }

        .head-and-text h6 {
            font-size: 14px;
        }

        .head-and-text p {
            font-size: 13px;
        }

        .prepare-by-falconzone {
            text-align: right;
        }

        .prepare-by-falconzone h6 {
            font-size: 14px;
        }

        .prepare-by-falconzone p {
            font-size: 13px;
        }

        .communication {
            background: #D9D9D9;
            border-radius: 30px;
            padding: 10px 10px;
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 20px;
        }

        .hotline {
            display: flex;
            justify-content: start;
            align-items: center;
            gap: 10px
        }

        .mail {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 10px
        }

        .whatsapp {
            display: flex;
            justify-content: end;
            align-items: center;
            gap: 10px
        }

        .fontsize-10px {
            font-size: 11px;
            line-height: 0.5;
        }

        .icon-fontsize i {
            font-size: 25px;
        }

        /*====last area start====*/
    </style>

    @php
        $setting = App\Models\GeneralSetting::latest()->first();
    @endphp
</head>

<body>
    <div class="full">
        @foreach ($orders as $order)
            <!-- ==first area start== -->
            <div class="first-area ">
                <!-- ==logo and address start== -->
                <div class="first-area-logo-and-address">
                    <div class="container order_description">
                        <div class="row">
                            <div class="col-lg-12 first-area-l-and-a">
                                <div class="first-area-logo mb-2">
                                    <img src="{{ asset('storage/' . $setting->logo) }}" alt="logo">

                                </div>
                            </div>
                            <div class="col-lg-12 first-area-l-and-a">
                                <div class="invoice_address_details">
                                    <p> {!! $setting->invoice_address_details !!} </p>
                                </div>
                            </div>
                            {{-- <div class="col-lg-12 first-area-l-and-a">
                                <p>Mirpur-10,Dhaka-1216</p>
                            </div> --}}
                            {{-- <div class="col-lg-12 first-area-l-and-a">
                               <div class="invoice_number">
                                    <p>Call:{{ $setting->header_contact_number }}</p>
                               </div>
                            </div> --}}
                            <div class="col-lg-12 first-area-l-and-a">
                                <div class="first-area-logo-and-address-border-bottom">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ==logo and address end== -->


                <!-- ==first area invoice start== -->
                <div class="container order_description">
                    <div class="first-area-invoice">
                        <div class="first-area-invoice-left">
                            <div class="first-area-invoice-text">
                                <h3><b>
                                        {{ $order->courier->name ?? '' }}
                                    </b></h3>
                                <h3><b>INVOICE</b></h3>
                            </div>
                            <div class="first-area-invoice-bill-and-client">
                                <p><b>Bill To</b></p>
                                <p><b>{{ $order->customer->name ?? '' }} </b></p>
                            </div>
                            <div class="first-area-invoice-mobail-no">
                                <div class="call">
                                    <p><b>Call:</b></p>
                                </div>
                                <div class="number">
                                    <p>{{ $order->customer_phone ?? '' }}</p>
                                </div>
                            </div>
                            <div class="first-area-invoice-address invoice_address_table_cell">
                                <div class="address-text">
                                    <p><b>Address:</b></p>
                                </div>
                                <div class="full-address invoice_top_address">
                                    <p>
                                        @if (!empty($order->customer->address))
                                            {{ $order->customer->address . ',' }}
                                        @endif
                                    </p>
                                </div>
                            </div>
                        </div>


                        <div class="first-area-invoice-right">
                            <div class="qr_code my-3 text-center">
                                @if ($order->memo_no)
                                    {!! QrCode::size(50)->generate($order->memo_no??'no memo') !!}
                                @endif
                            </div>
                            <div class="invoice-time-and-no">
                                <div class="invoice-time">
                                    <p>Date: <?php echo date('d/m/Y'); ?></p>
                                </div>
                                <div class="invoice-no">
                                    <p><b>Invoice no: {{ $order->invoice_no }}</b></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ==first area invoice end== -->
            </div>
            <!-- ==first area end== -->



            <!-- ==middle area start== -->
            <div class="middle-area">
                <div class="container order_description">
                    <div class="row">
                        <div class="col-lg-12">
                            <table class="table invoice_table_bg_th">
                                <tr>
                                    <th colspan="1">Item Description</th>
                                    <th>Size</th>
                                    <th colspan="2">Price</th>
                                    <th colspan="1">Qty</th>
                                    <th colspan="1">Total</th>
                                </tr>
                                @foreach ($order->orderItem as $k => $item)
                                    <tr>
                                        <td colspan="1">{{ $item->product->name }} {{ $item->product->product_code }}
                                        </td>
                                        <td class="text-right">{{ $item->size ?? '-' }}</td>
                                        <td colspan="2" class="text-right">{{ $item->price }}</td>
                                        <td colspan="1" class="text-right">{{ $item->quantity }}</td>
                                        <td colspan="1" class="text-right"> {{ $item->quantity * $item->price }} </td>
                                    </tr>
                                @endforeach

                                <tr>
                                    <td colspan="5" class="text-right"> Shipping Charge </td>
                                    <td class="text-right"><span style="font-size: 13px;">{{ $order->shipping_cost }}
                                            Tk</span></td>
                                </tr>
                                <tr>
                                    <td colspan="5" class="text-right">Total:</td>
                                    <td class="text-right">
                                        <span style="font-weight:bold;font-size:13px;">
                                            {{ $order->shipping_cost + $order->total }} TK</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="5" class="text-right">Discount:</td>
                                    <td class="text-right"> {{ $order->discount }} Tk</td>
                                </tr>
                                <tr>
                                    <td colspan="5" class="text-right">Paid:</td>
                                    <td class="text-right"> {{ $order->paid }} Tk</td>
                                </tr>
                                <tr>
                                    <td colspan="5" class="text-right">Amount Due:</td>
                                    <td class="text-right">
                                        {{ $order->total - ($order->paid + $order->discount) + $order->shipping_cost }} Tk
                                    </td>
                                </tr>


                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <!-- ==middle area end== -->
        @endforeach


        <!-- ==last area start== -->
        <div class="last-area">
            <div class="container order_description">

                <div class="last-area-term-and-prepare">
                    <div class="head-and-text">
                        <h6><b>Term and conditions:</b></h6>
                        <p>sold items non refundable please do your prayers and inspire others</p>
                    </div>

                    <div class="prepare-by-falconzone">
                        <h6><b>Prepare By</b></h6>
                        <p>{{ $setting->title }}</p>
                    </div>
                </div>



                <div class="communication">


                    <div class="hotline">
                        <div class="hotline-icon icon-fontsize">
                            <i class="fa fa-phone-square"></i>
                        </div>
                        <div class="hotline-head-and-text fontsize-10px">
                            <h6><b>Hotline</b></h6>
                            <p>{{ $setting->header_contact_number }}</p>
                        </div>

                    </div>


                    <div class="mail">
                        <div class="mail-icon icon-fontsize">
                            <i class="fa fa-envelope-o" aria-hidden="true"></i>
                        </div>
                        <div class="mail-head-and-text fontsize-10px">
                            <h6><b>mail</b></h6>
                            <p>{{ $setting->header_email }}</p>
                        </div>
                    </div>


                    <div class="whatsapp">
                        <div class="whatsapp-icon icon-fontsize">
                            <i class="fa fa-whatsapp"></i>
                        </div>
                        <div class="whatsapp-head-and-text fontsize-10px">
                            <h6><b>whatsapp</b></h6>
                            <p>{{ $setting->whatsapp_number }}</p>
                        </div>
                    </div>

                </div>



                <h6 style="text-align: center; margin-top: 5px; font-size: 15px;">
                    <B>THANK YOU FOR SHOPPING</B>
                </h6>


            </div>
        </div>
    </div>


</body>

</html>
