<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css"
        integrity="sha384-Vkoo8x4CGsO3+Hhxv8T/Q5PaXtkKtu6ug5TOeNV6gBiFeWPGFN9MuhOf23Q9Ifjh" crossorigin="anonymous">
    <link href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
    <title>Print || Invoice</title>

    <?php
    $setting = App\Models\GeneralSetting::latest()->first();
    ?>
    <style>
        @page {
            size: A4;
            margin: 15mm;
        }

        @media print {
            * {
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
                color-adjust: exact !important;
            }

            body {
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
                background: white !important;
                margin: 0;
                padding: 0;
            }

            .page-break {
                page-break-after: always;
                width: 100%;
                margin: 0 auto;
                padding: 0;
            }

            .print,
            .btn-pr,
            #print {
                display: none !important;
            }

            .table td,
            .table th {
                page-break-inside: avoid;
            }

            .moha_add_inv p,
            .customer_info_list li {
                color: #000 !important;
            }

            .table thead th {
                background-color: #F4F6F9;
            }
        }

        body {
            background: #ddd;
            font-size: 14px;
        }

        .invoice_header_both_section {
            display: flex;
            align-items: start;
            gap: 40px;
        }

        .invoice_header_left_section {
            width: 55%;
        }

        .invoice_header_right_section {
            width: 45%;
            text-align: right;
        }

        .moha_add_inv {
            margin: 0px;
            padding: 0px;
        }

        .moha_add_inv p {
            margin: 0px;
            padding: 0px;
            font-weight: 500;
        }

        .print {
            background: #fff;
            padding: 28px;
            display: block;
        }

        .page-break {
            background-color: #fff;
            padding: 25px;
            margin-bottom: 10px;
            width: 210mm;
            min-height: 297mm;
            box-sizing: border-box;
        }

        th {
            background-color: #04AA6D !important;
            color: #000 !important;
        }

        .btn-pr {
            text-align: right;
            display: block;
            position: fixed;
            right: 0;
            top: 280px;
            z-index: 9999;
        }

        .btn-pr button {
            height: 50px;
        }

        .rotate-logo {
            position: fixed;
            left: 30%;
            top: 30%;
            width: 502px;
            font-size: 24px;
            opacity: 0.2;
        }

        .rotate-logo img {
            width: 350px;
        }

        .customer_info_list {
            border: 2px dashed #dddddd;
        }

        .customer_info_list li {
            list-style-type: square;
            padding: 2px 0px;
            text-align: left;
        }

        .company_logo {
            height: 55px;
            margin-bottom: 4px;
        }

        .table td,
        .table th {
            padding: .30rem;
            vertical-align: middle;
            border-top: 1px solid #dee2e6;
        }
    </style>


    @php

        function countOrderTotayQty($orderItem)
        {
            $total_qty = 0;
            foreach ($orderItem as $item) {
                $total_qty += $item->quantity;
            }
            return $total_qty;
        }
    @endphp

</head>

<body>
    <div class="btn-pr">
        <button class="btn btn-success text-center print-button" onclick="allPrint()" id="print"><i
                class="fa fa-print"></i></button>
    </div>
    @foreach ($orders as $order)
        <div class="container page-break">
            <div class="row justify-content-center">
                <div class="col-lg-11 col-md-11 col-lg-offset-1 col-md-offset-1 invoice_header_both_section">
                    <div class="invoice_header_left_section">
                        <ul class="customer_info_list">
                            <li> <strong> Name: </strong>{{ $order->customer->name ?? '' }} </li>
                            <li> <strong> Mobile: </strong>{{ $order->customer_phone ?? '' }} </li>
                            <li> <strong> Address: </strong>
                                @if (!empty($order->customer->address))
                                    {{ $order->customer->address . ',' }}
                                @endif
                                @if (!empty($order->sub_city->name))
                                    {{ $order->sub_city->name . ',' }}
                                @endif
                                {{ $order->city->name ?? '' }}.

                            </li>
                            <li> <strong> Invoice No: </strong>{{ $order->invoice_no }} </li>
                            @if ($order->courier)
                                <li> <strong> Courier: </strong>{{ $order->courier->name ?? '' }} </li>
                            @endif
                        </ul>
                        @if ($order->consignment_id)
                            <h4>Courier ID: {{$order->consignment_id}}</h4>
                        @endif
                    </div>
                    <div class="invoice_header_right_section">
                        @if ($order->reseller_id)
                            @if ($order->is_referred == 1)
                                <h3>{{ $order->referred_name }}</h3>
                            @else
                                <img class="company_logo" src="{{ asset('storage/' . $order->reseller->logo) }}"
                                    alt="{{ $order->reseller->company_name }}">
                            @endif
                        @else
                            <img class="company_logo" src="{{ asset('storage/' . $setting->logo) }}" alt="logo">
                        @endif



                        <div class="moha_add_inv">

                            @if ($order->reseller_id)
                                <p>{{ $order->reseller->company_name }}</p>
                                <p>{{ $order->reseller->company_phone ? $order->reseller->company_phone : $order->reseller->phone }}
                                </p>
                            @else
                                <p> {!! $setting->invoice_address_details !!} </p>
                            @endif

                            <p class="current_date ">
                                <strong> Date: <span style="border:1px solid #ddd"> <?php echo date('d/m/Y'); ?></span> </strong>
                            </p>
                            <div class="qr_code mt-2">
                                @if ($order->memo_no)
                                    {!! QrCode::size(50)->generate($order->memo_no??'no memo') !!}
                                @endif
                            </div>

                        </div>
                    </div>
                </div>
            </div>



            <div class="row justify-content-center">
                <div class="col-lg-11 col-md-11 col-lg-offset-1 col-md-offset-1">
                    <table class="table table-bordered moha_tbl_inv mt-4" style="margin-top: 5px;">
                        <tbody>
                            @if ($order->note)
                                <tr>
                                    <td colspan="7" class="text-left"><b> Note : {{ $order->note }} </b></td>
                                </tr>
                            @endif

                            <tr>
                                <th style="background-color: #ddd !important;" class="text-left ">No</th>
                                <th style="background-color: #ddd !important;" class="text-left ">Product Details</th>

                                @foreach ($variantHeaders as $header)
                                    <th style="background-color: #ddd !important;" class="text-left">
                                        {{ $header }}</th>
                                @endforeach

                                {{-- <th style="background-color: #ddd !important;width: 85px;" class="text-left;">Order No </th> --}}
                                <th style="background-color: #ddd !important;" class="text-right ">Price</th>
                                <th style="background-color: #ddd !important;" class="text-right ">Qty</th>
                                <th style="background-color: #ddd !important;" class="text-right ">Total</th>
                            </tr>

                            @foreach ($order->orderItem as $k => $item)
                                <tr>
                                    <td class="text-center">{{ $k + 1 }}</td>
                                    <td class="text-left" style="text-transform: capitalize;">
                                        <img src="{{ asset('storage/' . $item->product->thumbnail_img) }}"
                                            alt="logo" width="60px" height="60px">
                                        {{ $item->product->name }} {{ $item->product->product_code }} @if ($item->status == 3)
                                            <b> [ exchange ]</b>
                                        @endif
                                    </td>

                                    @foreach ($variantHeaders as $header)
                                        <td>
                                            @php
                                                $variantValue = '-';
                                                foreach ($item->variants as $variant) {
                                                    if ($variant->variant_atribute == $header) {
                                                        $variantValue = $variant->variant_name;
                                                        break;
                                                    }
                                                }
                                            @endphp
                                            {{ $variantValue }}
                                        </td>
                                    @endforeach

                                    {{-- <td class="text-center">{{ $item->id }}</td> --}}
                                    <td class="text-center">{{ $item->price }}</td>
                                    <td class="text-center"><span style="border: 1px solid #ddd;"><b
                                                style="font-size: 16px;padding:5px 5px 5px 5px;">{{ $item->quantity }}</b></span>
                                    </td>
                                    <td class="text-right">{{ $item->quantity * $item->price }} Tk</td>
                                </tr>
                            @endforeach


                            @php
                                $variantCount = count($variantHeaders);
                                $totalColspan = 3 + $variantCount;
                                $summaryColspan = 4 + $variantCount;
                            @endphp

                            <tr>
                                <td colspan="{{ $totalColspan }}" class="text-right"> Total Quantity and Shipping
                                    Charge </td>
                                <td><strong> = {{ countOrderTotayQty($order->orderItem) }} </strong></td>
                                <td class="text-right"><span style="font-size: 13px;">{{ $order->shipping_cost }}
                                        Tk</span></td>
                            </tr>
                            <tr>
                                <td colspan="{{ $summaryColspan }}" class="text-right">Total:</td>
                                <td class="text-right">
                                    <span
                                        style="font-weight:bold;font-size:13px;">{{ $order->shipping_cost + $order->total }}
                                        TK
                                        <br>
                                        @if ($order->coupon_disocunt)
                                            <small style="font-size: 10px; color: red">
                                                Coupon Discount : {{ $order->coupon_disocunt }}
                                            </small>
                                        @endif
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="{{ $summaryColspan }}" class="text-right">Discount:</td>
                                <td class="text-right">{{ $order->discount }} Tk</td>
                            </tr>
                            <tr>
                                <td colspan="{{ $summaryColspan }}" class="text-right">Paid:</td>
                                <td class="text-right">{{ $order->paid }} Tk</td>
                            </tr>
                            <tr>
                                <td colspan="{{ $summaryColspan }}" class="text-right">Amount Due:</td>
                                <td class="text-right">
                                    {{ $order->total - ($order->paid + $order->discount) + $order->shipping_cost }} Tk
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <p style="margin-top:-8px;"> <b><i> **No replace will be accepted after 7 days</i></b></p>
                </div>
            </div>
        </div>
    @endforeach
    <script>
        function allPrint() {
            window.print();
        };

        window.addEventListener('DOMContentLoaded', (event) => {
            window.print();
        });
    </script>

</body>

</html>
