{{-- <!doctype html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css" integrity="sha384-Vkoo8x4CGsO3+Hhxv8T/Q5PaXtkKtu6ug5TOeNV6gBiFeWPGFN9MuhOf23Q9Ifjh" crossorigin="anonymous">
    <link href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
    <title>Label Print</title>
    <?php
        $setting = App\Models\GeneralSetting::latest()->first();
    ?>
</head>
<body>
<div class="btn-pr">
    <button class="btn btn-success text-center print-button" onclick="allPrint()" id="print"><i class="fa fa-print"></i></button>
</div>
<div class="container page-break">
    <div class="row justify-content-center break">
        <div class="col-lg-4  ml-5">
            <div class="header-left ml-4 text-left">
                <img class="inv_logo" src="{{ asset('storage/'.$setting->logo) }}" alt="logo" width="240px">
               
            </div>
        </div>
        <div class="col-lg-6">
            <div class="pull-right moha_add_inv" >
                <p class="logo"> {{ $setting->title }} </p>
                <p> {!! $setting->invoice_address_details !!} </p>
                <p class="pull-right current_date" style="display: block;overflow: hidden;line-height: 30px;border:1px solid #dddddd;">
                    <span style="padding:2px 4px 2px 4px;">
                        Date :
                    </span>
                    <span style="padding:2px 4px 2px 4px;">
                        <?php echo date("d/m/Y"); ?>
                    </span>
                </p>
            </div>
        </div>
    </div>
    <div class="row justify-content-center" style="margin-top: 6px;">
        <div class="col-lg-12">

            <table class="table table-bordered">
                <thead>


                <tr style="text-align: center;">
                    <th>SL No.</th>
                    <th>Customer Name</th>
                    <th>Customer Mobile</th>
                    <th>Address</th>
                    <th>COD</th>
                    <th>Invoice No.</th>
                    <th>Courier</th>
                </tr>
                </thead>
                <tbody>

                @foreach($orders as $k=> $order)
                    <tr style="text-align: center;">
                        <td>{{$k+1}}</td>
                        <td>
                           {{ $order->customer->name ?? "" }}
                        </td>
                        <td>
                           {{ $order->customer_phone }}
                        </td>
                        <td>
                            {{ $order->city->name ?? "" }}
                        </td>
                        <td>
                           {{ ($order->total)-($order->paid+$order->discount)+$order->shipping_cost }}


                        </td>
                        <td>{{$order->invoice_no}}</td>
                        <td>
                        {{ $order->courier->name ?? "" }}
                        </td>
                    </tr>
                @endforeach





                </tbody>
            </table>


        </div>
    </div>

</div>




<style>

    .pull-right.moha_add_inv p {
        line-height: 22px;
        margin-bottom: 5px;
    }
    .pull-right.moha_add_inv {
        text-align: right;
        margin-right: 120px !important;
        margin-top: 20px;
    }



    body {
        background: #ddd;
    }

    .print {
        background: #fff;
        padding:28px;
        display:block;
    }
    .page-break {
        page-break-after: always;
        background-color: #fff;
        padding-bottom: 50px;
        padding-top: 50px;
        margin-bottom: 20px;
        width: 70%;
    }
    .col-lg-4{
        text-align: center;
        width: 35% !important;
        margin: 0;
        padding:0;
        margin-left: 20px;
    }
    .col-lg-6{
        text-align: center;
        width: 60% !important;
        margin: 0;
        padding:0;
    }
    @media print {
        #print {
            display: none;
        }
    }
    .btn-pr{
        text-align: right;
        display: block;
        position: fixed;
        right:0;
        top: 280px;
    }
    .btn-pr button{
        height: 50px;
    }


</style>

<script>
    function allPrint() {
       window.print();
    };

    window.addEventListener('DOMContentLoaded', (event) => {
        window.print();
        window.localStorage();
    });

</script>

</body>
</html> --}}







<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Label Print</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      font-size: 13px;
      background: #fff;
      width: 280px; /* 80mm paper ≈ 280px */
      margin: 0 auto;
      padding: 0;
        -webkit-print-color-adjust: exact !important;
        print-color-adjust: exact !important;
    }

    .invoice_content {
      width: 100%;
      padding: 10px;
      box-sizing: border-box;
      border: 1px dashed #333;
      margin-bottom: 3px;
    }

    .invoice_header {
      text-align: center;
      margin-bottom: 10px;
    }

    .logo img {
      height: 30px;
    }

    .shop_name h4 {
      margin: 5px 0;
      font-size: 14px;
      font-weight: normal;
    }

    .invoice_no span {
      font-size: 13px;
    }

    .barcode {
        display: flex;
        justify-content: center;
        align-items: center;
        margin: 15px 0;
    }

    .barcode img {
      height: 30px;
    }
    .invoice_no {
        margin-top: 8px;
    }

    .invoice_body p {
      margin: 10px 0;
      font-size: 13px;
      display: flex;
    }

    .invoice_body b {
      display: inline-block;
      width: 65px;
      font-weight: bold;
    }

    .invoice_body span {
      flex: 1;
    }
    .print_icon {
        position: fixed;
        top: 30%;
        right: 0;
        background-color: #218838;
        color: #ffffff;
        border: none;
        padding: 5px 7px;
        border-radius: 3px 0px 0px 3px;
        cursor: pointer;
    }
    * {
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        }
    @media print {
        * {
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        }
      body {
        margin: 0;
        padding: 0;
        width: 100%;
      }
      .invoice_content {
        width: 100%;
        padding: 0px;
        border: 0;
        margin-bottom: 0px;
        page-break-after: always;
        padding-top: 10px;
      }
      .print_icon {
            display: none;
        }
    }
  </style>
    <?php
        $setting = App\Models\GeneralSetting::latest()->first();
    ?>
</head>
<body>
    <button class="print_icon" onclick="allPrint()" id="print">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-printer"><polyline points="6 9 6 2 18 2 18 9"></polyline><path d="M6 18H4a2 2 0 0 1-2-2v-5a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-2"></path><rect x="6" y="14" width="12" height="8"></rect></svg>
    </button>
    @foreach($orders as $k=> $order)
        <div class="invoice_content">
            <div class="invoice_header">
                <div class="logo">
                    <img src="{{ asset('storage/'.$setting->logo) }}" alt="logo">
                </div>
                <div class="shop_name">
                    <h4>{{ $setting->title }}</h4>
                </div>
                <div class="invoice_no">
                    <span>Invoice ID: {{$order->invoice_no}}</span>
                </div>
            </div>
            
            <div class="barcode">
                 {!! DNS1D::getBarcodeHTML($order->invoice_no, 'C128') !!} 
            </div>

            <div class="invoice_body">
                <p><b>Name:</b> <span>{{ $order->customer->name ?? "" }}</span></p>
                <p><b>Phone:</b> <span>{{ $order->customer_phone }}</span></p>
                <p><b>Address:</b> <span>{{ $order->customer->address ?? "" }}</span></p>
                <p><b>COD:</b> <span>{{ ($order->total)-($order->paid+$order->discount)+$order->shipping_cost }}</span></p>
            </div>
        </div>
    @endforeach


    <script>
        function allPrint() {
            window.print();
        };

        window.addEventListener('DOMContentLoaded', (event) => {
            window.print();
        });
    </script>

</body>
</html>






