<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Print || Invoice</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Arial', sans-serif;
            width: 80mm;
            margin: 0 auto;
            background: #fff;
            color: #000;
        }

        #invoice {
            width: 100%;
            border: 1px solid #dddddd;
            padding: 10px;
            margin-top: 3px;
        }

        h2 {
            text-align: center;
            margin-bottom: 5px;
        }

        .center {
            text-align: center;
        }

        .invoice_header {
            padding-bottom: 10px;
        }

        .logo img {
            height: 40px;
        }

        .shop_name h4 {
            font-size: 15px;
            margin-top: 10px;
        }

        .info,
        .items,
        .summary {
            margin-top: 20px;
            font-size: 13px;
        }

        .info p {
            margin: 5px 0;
            line-height: 22px;
        }

        .items table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        .items th,
        .items td {
            text-align: left;
            padding: 4px 0;
            font-size: 13px;
        }

        .items td:last-child,
        .items th:last-child {
            text-align: right;
        }

        .summary {
            margin-top: 0px;
            padding-top: 5px;
        }

        .summary p {
            display: flex;
            justify-content: space-between;
            margin: 10px 0;
        }

        .words {
            margin-top: 20px;
            font-size: 13px;
            display: block;
            width: 100%;
        }

        .words strong {
            line-height: 20px;
        }

        .footer {
            text-align: center;
            font-size: 13px;
            margin-top: 14px;
        }

        .footer p {
            margin-bottom: 5px;
        }

        .barcode {
            display: flex;
            justify-content: center;
            align-items: center;
            margin-top: 20px;
        }

        span.items_name {
            line-height: 18px;
        }

        .items_name {
            font-weight: bold;
            font-size: 13px;
            line-height: 18px;
        }

        .pos_price p {
            text-align: left;
            display: block;
            line-height: 20px;
        }

        .pos_qty_price {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-top: 5px;
        }

        .print_icon {
            position: fixed;
            top: 30%;
            right: 0;
            background-color: #218838;
            color: #ffffff;
            border: none;
            padding: 5px 7px;
            border-radius: 3px 0px 0px 3px;
            cursor: pointer;
        }
        .justify-content-between {
            display: flex;
            justify-content: space-between;
        }

        * {
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        }

        @media print {
            * {
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
            }

            body {
                width: 80mm;
                margin: 0 auto;
                background: #fff;
            }

            .page-break {
                page-break-after: always;
            }

            #invoice {
                width: 100%;
                border: none;
                border-bottom: 1px solid #dddddd;
                margin-top: 0px;
                padding-bottom: 10px !important;
            }

            .print_icon {
                display: none;
            }
        }
    </style>
    <?php
    $setting = App\Models\GeneralSetting::latest()->first();
    ?>
</head>

<body>
    <button class="print_icon" onclick="allPrint()" id="print">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
            class="feather feather-printer">
            <polyline points="6 9 6 2 18 2 18 9"></polyline>
            <path d="M6 18H4a2 2 0 0 1-2-2v-5a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-2"></path>
            <rect x="6" y="14" width="12" height="8"></rect>
        </svg>
    </button>

    @foreach ($orders as $order)
        <div id="invoice">
            <div class="invoice_header">
                <div class="logo center">
                    <img src="{{ asset('storage/' . $setting->logo) }}" alt="logo">
                </div>
                <div class="shop_name center">
                    <h4>{{ $setting->title }}</h4>
                </div>
            </div>

            <div class="info">
                <div class="justify-content-between">
                    <div>
                        <p><strong>Date:</strong> {{ $order->created_at->toDateString() }}</p>
                        <p><strong>Invoice ID:</strong> <strong>{{ $order->invoice_no }}</strong></p>
                    </div>
                    @if ($order->memo_no)
                        <div class="qr_code">
                            {!! QrCode::size(50)->generate($order->memo_no ?? 'no memo') !!}
                        </div>
                    @endif
                    
                </div>
                <p><strong>Customer:</strong> {{ $order->customer->name ?? '' }}</p>
                <p>
                    @if (!empty($order->customer->address))
                        {{ $order->customer->address . ',' }}
                    @endif
                    @if (!empty($order->sub_city->name))
                        {{ ',' . $order->sub_city->name . ',' }}
                    @endif
                    {{ $order->city->name ?? '' }}
                </p>
                <p>{{ $order->customer_phone ?? '' }}</p>
            </div>

            <div class="items">
                <table>
                    <tbody>
                        @foreach ($order->orderItem as $k => $item)
                            <tr>
                                <td>
                                    <div class="pos_price">
                                        <p>{{ $item->product->name }} - ({{ $item->product->product_code }})
                                            @if ($item->status == 3)
                                                <b> [ exchange ]</b>
                                            @endif
                                            </span>
                                        </p>
                                    </div>
                                    <div class="pos_qty_price">
                                        <span>{{ $item->quantity }} × {{ $item->price }}</span>
                                        <span>{{ number_format($item->quantity * $item->price, 2) }}</span>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="summary">
                @php
                    $calculatedTotal = 0;
                    foreach ($order->orderItem as $item) {
                        $calculatedTotal += $item->quantity * $item->price;
                    }
                    $grandTotal = $calculatedTotal + $order->shipping_cost - $order->discount;

                    if (!function_exists('numberToWordsBDT')) {
                        function numberToWordsBDT($num)
                        {
                            $ones = [
                                '',
                                'One',
                                'Two',
                                'Three',
                                'Four',
                                'Five',
                                'Six',
                                'Seven',
                                'Eight',
                                'Nine',
                                'Ten',
                                'Eleven',
                                'Twelve',
                                'Thirteen',
                                'Fourteen',
                                'Fifteen',
                                'Sixteen',
                                'Seventeen',
                                'Eighteen',
                                'Nineteen',
                            ];
                            $tens = [
                                '',
                                '',
                                'Twenty',
                                'Thirty',
                                'Forty',
                                'Fifty',
                                'Sixty',
                                'Seventy',
                                'Eighty',
                                'Ninety',
                            ];

                            if ($num == 0) {
                                return 'Zero Taka Only';
                            }

                            $words = '';

                            if ($num >= 100000) {
                                $words .= $ones[intval($num / 100000)] . ' Lakh ';
                                $num %= 100000;
                            }
                            if ($num >= 1000) {
                                $words .= $ones[intval($num / 1000)] . ' Thousand ';
                                $num %= 1000;
                            }
                            if ($num >= 100) {
                                $words .= $ones[intval($num / 100)] . ' Hundred ';
                                $num %= 100;
                            }

                            if ($num > 0) {
                                if ($num < 20) {
                                    $words .= $ones[$num];
                                } else {
                                    $words .= $tens[intval($num / 10)];
                                    if ($num % 10 > 0) {
                                        $words .= '-' . $ones[$num % 10];
                                    }
                                }
                            }

                            return trim($words) . ' Taka Only';
                        }
                    }

                @endphp
                <p><strong>Total:</strong> <strong>{{ number_format($calculatedTotal, 2) }}</strong></p>
                <p><strong>Grand Total:</strong> <strong>{{ number_format($grandTotal, 2) }}</strong></p>
            </div>

            <div class="words center">
                <strong>In Words: BDT {{ numberToWordsBDT($grandTotal) }}</strong>
            </div>

            <div class="footer">
                <p>Thank You For Shopping With Us.</p>
                <p>Please Come Again</p>
            </div>
            {{-- 
        <div class="barcode">
            {!! DNS1D::getBarcodeHTML($order->invoice_no, 'C128') !!} 
        </div> --}}

        </div>
        <div class="page-break"></div>
    @endforeach


    <script>
        function allPrint() {
            window.print();
        };

        window.addEventListener('DOMContentLoaded', (event) => {
            window.print();
        });
    </script>

</body>

</html>
