<!doctype html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <title>Print || Invoice</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <!-- Bootstrap -->
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">

  <style>
    @page {
      size: A4 portrait;
      margin: 10mm 15mm;
    }
    * {
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        }
    body {
      background: #f1f1f1;
      font-size: 14px;
      padding: 0;
      margin: 0;
    }

    .btn-pr {
      position: fixed;
      right: 20px;
      top: 20px;
      z-index: 9999;
    }

    .btn-pr button {
      height: 50px;
    }

    .page-break {
      background-color: #fff;
      padding: 25px;
      margin: 20px auto;
      width: 210mm;
      min-height: 297mm;
      box-sizing: border-box;
      box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
    }

    .company_logo {
      height: 55px;
      margin-bottom: 4px;
    }

    .invoice_header_both_section {
      display: flex;
      justify-content: space-between;
      align-items: flex-start;
      gap: 20px;
    }

    .moha_add_inv p {
      margin: 0;
      padding: 0;
      font-weight: 500;
    }

    .customer_info_list {
        border: 2px dashed #ddd;
        padding: 10px 10px 10px 30px;
    }
    .invoice_header_right_section {
        text-align: right;
    }

    .customer_info_list li {
      list-style-type: square;
      padding: 2px 0;
    }

    .table td,
    .table th {
      padding: .4rem;
      vertical-align: middle;
      border-top: 1px solid #dee2e6;
    }

    .inv_logo {
      height: 55px;
    }

    .text-uppercase {
      text-transform: uppercase;
    }

    p.note {
      margin-top: -5px;
      font-style: italic;
      font-size: 12px;
    }

    .signatures td {
      padding-top: 40px;
    }
    .table thead th {
        background-color: #dee2e6;
    }
    @media print {
          * {
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        }
      html,
      body {
        width: 210mm;
        height: 297mm;
        margin: 0;
        padding: 0;
        background: white !important;
        -webkit-print-color-adjust: exact !important;
        print-color-adjust: exact !important;
      }
        .table thead th {
        background-color: #dee2e6 !important;
        color: #000 !important;
        border-bottom: 2px solid #000;
        }
      .btn-pr,
      #print {
        display: none !important;
      }

      .page-break {
        page-break-after: always;
        page-break-inside: avoid;
        width: 100%;
        margin: 0 auto;
        background: white !important;
      }

      th {
        background-color: #04AA6D !important;
        color: black !important;
      }

      .table td,
      .table th {
        page-break-inside: avoid !important;
      }

      .moha_add_inv p,
      .customer_info_list li {
        color: #000 !important;
      }
      .table thead th {
            background-color: #dee2e6;
        }
    }
  </style>

  <?php
    $setting = App\Models\GeneralSetting::latest()->first();
  ?>

</head>

<body>
  <div class="btn-pr">
    <button class="btn btn-success" onclick="allPrint()" id="print"><i class="fa fa-print"></i> Print</button>
  </div>

  <div class="container page-break">
    <div class="invoice_header_both_section mb-1">
      <div class="invoice_header_left_section">
        <ul class="customer_info_list">
          <li><strong>Name:</strong> {{ $order->name ?? '' }}</li>
          <li><strong>Phone:</strong> {{ $order->mobile_no ?? '' }}</li>
          <li><strong>Invoice No:</strong> {{ $order->invoice_no }} -{{ $order->id }}</li>
          <li><strong>Address:</strong> <span class="text-uppercase">{{ $order->address ?? '' }}</span></li>
        </ul>
      </div>
      <div class="invoice_header_right_section">
        <img class="inv_logo" src="{{ asset('storage/' . $setting->logo) }}" alt="logo">
        <p>{!! $setting->invoice_address_details !!}</p>
        <p class="current_date mt-2">
          <strong>Date:</strong>
          <span>{{ date('d/m/Y') }}</span>
        </p>
      </div>
    </div>

    <table class="table table-bordered">
      <thead>
        <tr>
          <th class="text-center">No</th>
          <th class="text-left">Product Details</th>
          <th class="text-center">Size</th>
          <th class="text-center">Price</th>
          <th class="text-center">Qty</th>
          <th class="text-center">Total</th>
        </tr>
      </thead>
      <tbody>
        @foreach ($order->SaleItems as $k => $item)
        <tr>
          <td class="text-center">{{ $k + 1 }}</td>
          <td class="text-left text-capitalize">
            <img width="40" height="40" src="{{ asset('storage/' . $item->product->thumbnail_img) }}" alt="">
            {{ $item->product->name }} {{ $item->product->product_code }}
          </td>
          <td class="text-center">{{ $item->variant->name ?? '-' }}</td>
          <td class="text-center">{{ $item->price }}</td>
          <td class="text-center">{{ $item->qty }}</td>
          <td class="text-center">{{ $item->qty * $item->price }} Tk</td>
        </tr>
        @endforeach
        <tr>
          <td colspan="5" class="text-right"><strong>Sub-Total:</strong></td>
          <td class="text-right">{{ $order->total }} Tk</td>
        </tr>
        <tr>
          <td colspan="5" class="text-right">Discount:</td>
          <td class="text-right">{{ $order->discount }} Tk</td>
        </tr>
        <tr>
          <td colspan="5" class="text-right">Paid:</td>
          <td class="text-right">{{ $order->paid }} Tk</td>
        </tr>
        <tr>
          <td colspan="5" class="text-right"><strong>Amount Due:</strong></td>
          <td class="text-right"><strong>{{ $order->total - ($order->paid + $order->discount) }} Tk</strong></td>
        </tr>
      </tbody>
    </table>

    <p class="note">** No replace will be accepted after 7 days</p>

    <table class="w-100 signatures">
      <tr>
        <td>
          <p>Approved by<br>{{ $order->create_by->name ?? '' }}</p>
        </td>
        <td class="text-right">Accounts</td>
      </tr>
    </table>
  </div>

  <script>
    function allPrint() {
      window.print();
    }

    window.addEventListener('DOMContentLoaded', function () {
      window.print();
    });
  </script>
</body>

</html>
