@extends('frontend.app')
@section('title', 'Not Found')
@section('content')


    <?php
        $categories = DB::table('categories')->select('id', 'name', 'slug', 'icon_image')->where('status', 1)->orderBy('position', 'asc')->inRandomOrder()->latest()->limit(8)->get();
    ?>

    <!-- template one start -->
    @if ($site_configurations->template_id == 1)
    <div class="page_404_area section_padding">
        <div class="container">
            <div class="row gy-4 gx-4">
                <div class="col-12">
                    <div class="page_404_image">
                        <img src="{{ asset('frontend') }}/images/not-found.gif" alt="404">
                    </div>
                </div>
                <div class="col-12">
                    <div class="page_404_content">
                        <h2>Page Not Found..!</h2>
                        <p>The page you were looking for does not exit</p>
                        <a href="/" class="go_back_btn">Go back</a>
                        <span><b>or</b> check our category products</span>
                    </div>
                </div>
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="category_active owl-carousel">
                        @forelse ($categories as $category)
                            <div class="category_item">
                                <a href="{{ route('product.category', [$category->slug]) }}" class="category_item_link">
                                    <div class="category_image">
                                        <img src="{{ asset('storage/' . $category->icon_image) }}" alt="{{ $category->name }}">
                                    </div>
                                    <div class="category_name">
                                        <p>{{ $category->name }}</p>
                                    </div>
                                </a>
                            </div>
                        @empty
                            <div class="text-center">
                                <p>No category Found</p>
                            </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
    <!-- template one end -->

    <!-- template two start -->
    @if ($site_configurations->template_id == 3)
    <div class="page_404_area section_padding">
        <div class="container">
            <div class="row gy-4 gx-4">
                <div class="col-12">
                    <div class="page_404_image">
                        <img src="{{ asset('frontend') }}/images/not-found.gif" alt="404">
                    </div>
                </div>
                <div class="col-12">
                    <div class="page_404_content">
                        <h2>Page Not Found..!</h2>
                        <p>The page you were looking for does not exit</p>
                        <a href="/" class="go_back_btn">Go back</a>
                        <span><b>or</b> check our category products</span>
                    </div>
                </div>
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="category_active_template3 owl-carousel">
                        @forelse ($categories as $category)
                            <div class="category_item">
                                <a href="{{ route('product.category', [$category->slug]) }}" class="category_item_link">
                                    <div class="category_image">
                                        <img src="{{ asset('storage/' . $category->icon_image) }}" alt="{{ $category->name }}">
                                    </div>
                                    <div class="category_content">
                                        <p>{{ $category->name }}</p>
                                    </div>
                                </a>
                            </div>
                        @empty
                            <div class="text-center">
                                <p>No category Found</p>
                            </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
    <!-- template two end -->

@endsection