<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Payment Failed</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-beta1/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-giJF6kkoqNQ00vy+HMDP7azOuL0xtbfIcaT9wjKHr8RbDVddVHyTfAAsrekwKmP1" crossorigin="anonymous">
    <style>
        body {
            font-family: "Hind Siliguri", Sans-serif !important;
            background-color: #f5f5f5;
            box-sizing: border-box;
        }

        * {
            margin: 0;
            padding: 0;
        }

        .h1,
        .h2,
        .h3,
        .h4,
        .h5,
        .h6,
        h1,
        h2,
        h3,
        h4,
        h5,
        h6 {
            margin: 0;
            padding: 0;
        }

        p {
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 1083px;
            margin: 0 auto;
            padding: 20px 45px;
            text-align: center;
            background-color: #fff;
            border-radius: 4px;
            margin-top: 100px;
            border: 1px solid #eee;
            font-family: "Hind Siliguri", Sans-serif !important;
        }

        .fail_content_area .fail_heading {
            font-size: 34px;
            line-height: 40px;
            margin-top: 12px;
            padding-bottom: 18px;
            font-family: inherit;
            font-weight: 500;
        }

        .fail_subheading {
            font-size: 28px;
            font-weight: 500;
            font-family: inherit;
        }

        .fail_subheading {
            font-size: 22px;
            font-weight: 500;
            font-family: inherit;
        }

        .fail_message {
            font-size: 29px;
            font-weight: 500;
            margin-bottom: 18px;
            margin-top: 24px;
            font-family: inherit;
        }

        .highlight_payment_amount {
            font-weight: 600;
        }

        .fail_payment_info {
            border-bottom: 4px solid #eee;
            padding-bottom: 15px;
            margin-bottom: 15px;
        }

        .highlight_payment_status {
            color: #e74c3c;
            font-weight: 600;
        }

        .fail_reason_declined {
            padding: 12px 0px;
        }

        .fail_redirect_info {
            padding-bottom: 14px;
        }

        .response {
            color: #e74c3c;
            font-weight: bold;
        }

        @media screen and (max-width: 600px) {
            .container {
                padding: 20px 10px;
            }
        }
    </style>
    
    <?php
    $setting = DB::table('general_settings')->select('title')->latest()->first();
    ?>
</head>

<body>
    <div class="container">
        {{-- <h1>Sorry!! Please try again.</h1>
        <p>
            @if(isset($response))
            <span class="response">{{ $response }}</span> <br>
            @endif
            <a class="btn btn-warning" href="/checkout" class="go_back">Go back</a>
        </p> --}}


        <div class="fail_content_area">
            <h1 class="fail_heading">Redirecting to the Merchant Site</h1>
            <p class="fail_subheading">This may take a few seconds</p>
            <h2 class="fail_message">Sorry for your order</h2>
            <p class="fail_payment_info">
                Your payment of <span class="highlight_payment_amount">{{($order->total + $order->shipping_cost) - $order->discount}} BDT</span> is
                <span class="highlight_payment_status">FAILED (Payment Failed).</span>
                Payment ref id <strong class="payment_ref_id">{{$order->payment_id}}</strong>
            </p>
            <p class="fail_payment_channel">
                Payment Channel - bKash Payment Gateway
            </p>
            <p class="fail_reason_declined">
                Payment Failed - <strong class="label_reason_declined"> Reason for Declined </strong>
            </p>
            <p class="fail_redirect_info">
                You're now going back to <strong class="merchant_name"> <a href="/">{{$setting->title}}</a> </strong> in <span id="countdown">25</span> seconds...
            </p>
            <!--<p class="redirect_link">-->
            <!--    If you are not redirected, <a href="{{route('redirect.payment', $order->payment_id)}}" class="manual_redirect_link">click here</a>.-->
            <!--</p>-->
        </div>


    </div>

    <script>
        let timeLeft = 25; 
    
        function updateCountdown() {
            if (timeLeft <= 0) {
                window.location.href = "/";
            } else {
                document.getElementById("countdown").innerText = timeLeft;
                timeLeft--;
                setTimeout(updateCountdown, 1000);
            }
        }
    
        updateCountdown(); 
    </script>

</body>

</html>