<div class="col-xxl-3 col-xl-3 col-lg-4 col-md-4 col-sm-4 col-6">
    <div class="product_card ">
        <div class="product_image">
            <a href="{{ route('single.product', $product->slug) }}">
                <img src="{{ asset('storage/' . $product->thumbnail_img) }}" alt="{{ $product->name }}">
            </a>
            <div class="product_discount">
                <span>{{ getProductDiscountPrice($product->price, $product->sale_price) }}%</span>
            </div>
            <button class="cart_wishlist_btn" id="{{ $product->id }}" onclick="addToWishList(this.id)">
                <i class="fa-regular fa-heart"></i>
            </button>
        </div>
        <div class="product_content">
           @if ($product->stock <= 0 && $site_configurations->show_stock_out == 1)
                <div class="product_btn">
                    <a type="button" @disabled(true) class="product_btn_link_stock_out">
                        {{-- <i class="fa-solid fa-cart-plus"></i> --}}
                        OUT OF STOCK
                    </a>
                </div>
            @else
                <div class="product_btn">
                    <a onclick="addToCardFromHome(this.id)"type="button" id="{{ $product->id }}"
                        class="product_btn_link">
                        <i class="fa-solid fa-cart-plus"></i>
                        Add To Cart
                    </a>
                </div>
            @endif
            <div class="product_name">
                <a href="{{ route('single.product', $product->slug) }}" class="product_name_link">
                    <h2>{{ $product->name }}</h2>
                </a>
            </div>
            <div class="product_rating">
                @if ($product->avg_review)
                    @if ($product->avg_review >= 0 && $product->avg_review <= 5)
                        @for ($i = 1; $i <= 5; $i++)
                            @if ($product->avg_review >= $i)
                                <span><i class="fa-solid fa-star"></i></span>
                            @elseif ($product->avg_review >= $i - 0.5)
                                <span><i class="fa-regular fa-star"></i></span>
                            @else
                                <span> <i class="ion-ios-star-half"></i></span>
                            @endif
                        @endfor
                        @if ($product->review_ratings)
                            <span class="cart_rating_count">({{ $product->review_ratings }})
                                Reviews</span>
                        @endif
                    @endif
                @endif
            </div>
            <div class="product_price">
                <span class="product_new_price">{{ $product->sale_price }} TK</span>
                @if ($product->price > $product->sale_price)
                    <span class="product_discount_price">{{ $product->price }} TK</span>
                @endif
            </div>
        </div>
    </div>
</div>
