<div class="{{ $site_configurations->card_row }} col-xl-3 col-lg-4 col-md-4 col-sm-6 col-6">
    <div class="product_card">
        <a class="product_card_link" href="{{ route('single.product', $product->slug) }}">
            <div class="product_card_overlay"></div>
            <div class="product_image" style="aspect-ratio:{{ $site_configurations->image_aspect_ratio }}">
                <img src="{{ asset('storage/' . $product->thumbnail_img) }}" alt="{{ $product->name }}">
        
                @if ($product->discount)
                    <div class="product_discount">
                        <span>{{ getProductDiscountPrice($product->price, $product->sale_price) }}%</span>
                    </div>
                @endif
        
                @if ($product->is_free_delivery == 1)
                    <div class="fee_delivery">
                        <span>{{dynamic_lang('free_delivery')}}</span>
                    </div>
                @endif
        
                <div class="product_rating">
                    <span><i class="fa-regular fa-star"></i></span>
                    <span><i class="fa-regular fa-star"></i></span>
                    <span><i class="fa-regular fa-star"></i></span>
                    <span><i class="fa-regular fa-star"></i></span>
                    <span><i class="fa-regular fa-star"></i></span>
                    <span>({{$product->review_ratings ? $product->review_ratings : 0}})</span>
                </div>
            </div>
            <div class="product_content">
                <div class="product_name">
                    <p class="product_name_link">{{ $product->name }}</p>
                </div>
                @if ($product->author)
                    <div class="product_writer_name">
                        <p>{{ $product->author->name }}</p>
                    </div>  
                @endif
                <div class="product_price">
                    <span class="product_new_price">{{ $product->sale_price }} TK</span>
                    @if ($product->price > $product->sale_price)
                        <span class="product_discount_price">{{ $product->price }} TK</span>
                    @endif
                </div>
            </div>
        </a>
        <div class="hover_content">
            @if ($product->stock <= 0 && $site_configurations->show_stock_out == 1)
                <div class="product_btn">
                    <a class="product_btn_disable_link">
                        <i class="las la-ban"></i>
                        {{dynamic_lang('stock_out')}}
                    </a>
                </div>
            @else
                <div class="product_btn_group">
                    <div class="product_btn" id="popup_blur">
                        <a href="{{ route('single.product', $product->slug) }}" class="product_btn_link">{{dynamic_lang('add_to_cart')}}</a>
                    </div>
                </div>
            @endif
            <div class="product_details_btn">
                <a href="{{ route('single.product', $product->slug) }}" class="product_details_btn_link">View Details</a>
            </div>
        </div>
    </div>
</div>



<!-- Modal Template 2 Section add_to_cart -->
@include('frontend.components.add_to_cart_modal')
@include('frontend.components.order_now_modal')
<!-- Modal Template 2 Section Cart 2 -->
