<div class="modal fade product_click_card_modal" id="order_cart_modal{{ $product->id }}" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content cart_order_modal_container">
            <div class="modal-header">
                <h5 class="modal_cart_order_title">Order now this product</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="product_select_attribute_container_modal">
                    <p>Select {{ $product->productVariant[0]->attribute->name ?? 'Size' }}</p>
                    <div class="product_select_attribute_modal">
                        <ul>
                            @foreach ($product->productVariant as $item)
                                <li>
                                    <div class="select_size_name_modal"><span>{{ $item->variant->name }}</span></div>
                                    <div class="select_price_btn_modal">
                                        @if ($item->price > 0)
                                            <span class="select_price_modal">{{ $item->price }}TK</span>
                                        @else
                                            <span class="select_price_modal">{{ $product->sale_price }}TK</span>
                                        @endif

                                        <form id="buyNow_{{ $product->id }}_{{ $item->variant->id }}"
                                            action="{{ route('buy.now') }}" method="POST">
                                            @csrf
                                            <input type="hidden" id="form_product_id_{{ $item->variant->id }}"
                                                name="product_id" value="{{ $product->id }}">

                                            <input type="hidden" id="form_quantity_{{ $item->variant->id }}"
                                                name="quantity" value="1">
                                            <button
                                                onclick="submitBuyNowFormModal(event,{{ $product->id }},{{ $item->variant->id }}, '{{ $item->variant->name }}','{{ $product->productVariant[0]->attribute->name }}')"
                                                class="select_order_button">
                                                {{dynamic_lang('order_now')}}
                                            </button>
                                        </form>
                                    </div>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function submitBuyNowFormModal(event, productId, formId, variant, variantName) {
        event.preventDefault();

        const form = document.getElementById(`buyNow_${productId}_${formId}`);

        form.querySelectorAll('.variant-input').forEach(input => input.remove());

        let variants = {};
        if (variant && variantName) {
            variants[variantName] = variant;
        }

        // Dynamically add hidden inputs for each variant key-value pair
        for (const [key, value] of Object.entries(variants)) {
            const input = document.createElement('input');
            input.type = 'hidden';
            input.name = `variants[${key}]`;
            input.value = value;
            input.classList.add('variant-input');
            form.appendChild(input);
        }

        console.log('Form Variants:', variants);

        toastr.success('Order is processing, please wait...');

        // Submit the form
        form.submit();
    }
</script>
