<div class="product_card">
    <div class="product_image" style="aspect-ratio:{{ $site_configurations->image_aspect_ratio }}">
        <a href="{{ route('single.product', $product->slug) }}">
            <img src="{{ asset('storage/' . $product->thumbnail_img) }}" alt="{{ $product->name }}">
        </a>

        @if ($product->discount)
            <div class="product_discount">
                <span>{{ getProductDiscountPrice($product->price, $product->sale_price) }}%</span>
            </div>
        @endif




        @if ($product->is_free_delivery == 1)
            <div class="fee_delivery">
                <span>{{dynamic_lang('free_delivery')}}</span>
            </div>
        @endif

    </div>
    <div class="product_content">
        <div class="product_name">
            <a href="{{ route('single.product', $product->slug) }}" class="product_name_link">{{ $product->name }}</a>
        </div>
        <div class="product_price">
            <span class="product_new_price">{{ $product->sale_price }} TK</span>
            @if ($product->price > $product->sale_price)
                <span class="product_discount_price">{{ $product->price }} TK</span>
            @endif
        </div>
        <div class="product_rating">
            <span><i class="fa-regular fa-star"></i></span>
            <span><i class="fa-regular fa-star"></i></span>
            <span><i class="fa-regular fa-star"></i></span>
            <span><i class="fa-regular fa-star"></i></span>
            <span><i class="fa-regular fa-star"></i></span>
            <span>({{$product->review_ratings ? $product->review_ratings : 0}}) Reviews</span>
        </div>
        @if ($product->stock <= 0 && $site_configurations->show_stock_out == 1)
            <div class="product_btn">
                <a class="product_btn_disable_link">
                    <i class="las la-ban"></i>
                    {{dynamic_lang('stock_out')}}
                </a>
            </div>
        @else

            @php
                $hasVariants = isset($product->productVariant) && $product->productVariant->isNotEmpty();
            @endphp

            <div class="product_btn_group">
                {{-- <div class="product_btn" id="popup_blur">
                    <a class="product_btn_link" data-bs-toggle="modal" data-bs-target="#product_add_to_card_modal">Add To Cart</a>
                </div>
                <div class="product_btn">
                    <a class="product_btn_link" data-bs-toggle="modal" data-bs-target="#product_order_now_modal">Order Now</a>
                </div> --}}

                <div class="product_btn" id="popup_blur">
                    @if ($hasVariants)
                        <a class="product_btn_link" data-bs-toggle="modal" data-bs-target="#add_to_cart_modal{{ $product->id }}">{{dynamic_lang('add_to_cart')}}</a>
                    @else
                        <a class="product_btn_link" href="{{ route('single.product', $product->slug) }}">{{dynamic_lang('add_to_cart')}}</a>
                    @endif
                </div>
                <div class="product_btn">
                    @if ($hasVariants)
                        <a class="product_btn_link" data-bs-toggle="modal" data-bs-target="#order_cart_modal{{ $product->id }}">{{dynamic_lang('order_now')}}</a>
                    @else
                        <a class="product_btn_link" href="{{ route('single.product', $product->slug) }}">{{dynamic_lang('order_now')}}</a>
                    @endif
                </div>


            </div>
        @endif
    </div>
</div>


<!-- Modal Template 2 Section add_to_cart -->
@include('frontend.components.add_to_cart_modal')
@include('frontend.components.order_now_modal')

<!-- Modal Template 2 Section Cart 2 -->






