<div class="product_card">
    <div class="product_image" style="aspect-ratio:{{ $site_configurations->image_aspect_ratio }}">
        <a href="{{ route('single.product', $product->slug) }}">
            <img src="{{ asset('storage/' . $product->thumbnail_img) }}" alt="{{ $product->name }}">
        </a>

        @if ($product->discount)
            <div class="product_discount">
                <span>{{ getProductDiscountPrice($product->price, $product->sale_price) }}%</span>
            </div>
        @endif




        @if ($product->is_free_delivery == 1)
            <div class="fee_delivery">
                <span>{{dynamic_lang('free_delivery')}}</span>
            </div>
        @endif

    </div>
    <div class="product_content">
        <div class="product_name">
            <a href="{{ route('single.product', $product->slug) }}" class="product_name_link">{{ $product->name }}</a>
        </div>
        <div class="product_price">
            <span class="product_new_price">{{ $product->sale_price }} TK</span>
            @if ($product->price > $product->sale_price)
                <span class="product_discount_price">{{ $product->price }} TK</span>
            @endif
        </div>


        @php
            $hasVariants = isset($product->productVariant) && $product->productVariant->isNotEmpty();
        @endphp

        @if ($product->stock <= 0 && $site_configurations->show_stock_out == 1)
            <div class="product_btn">
                <a class="button_disable_add_to_cart">
                    <i class="fa-solid fa-cart-shopping"></i>
                    {{dynamic_lang('stock_out')}}
                </a>
            </div>
        @else
            @if(!$hasVariants)
            <div class="product_btn_group">
                <div class="product_btn">
                    <form 
                        action="{{ route('buy.now') }}" method="POST">
                        @csrf

                        <input type="hidden"  name="product_id" value="{{ $product->id }}">

                        <input type="hidden"  name="quantity" value="1">

                        <button  type="submit" class="product_btn_link">
                        {{dynamic_lang('order_now')}}
                        </button>
                    </form>
                </div>
            </div>
            @else
            <div class="product_btn_group">
                <div class="product_btn">
                    <a @if ($hasVariants)
                    href="{{ route('single.product', $product->slug) }}" @endif class="product_btn_link">
                        {{dynamic_lang('order_now')}}
                    </a>
                </div>
            </div>
            @endif
        @endif









        {{-- @php
            $hasVariants = isset($product->productVariant) && $product->productVariant->isNotEmpty();
        @endphp

        @if ($product->stock <= 0 && $site_configurations->show_stock_out == 1)
            <div class="product_btn">
                <a class="button_disable_add_to_cart">
                    <i class="fa-solid fa-cart-shopping"></i>
                    {{dynamic_lang('stock_out')}}
                </a>
            </div>
        @else
            @if(!$hasVariants)
            <div class="product_btn_group">
                <div class="product_btn">
                    <form 
                        action="{{ route('buy.now') }}" method="POST">
                        @csrf

                        <input type="hidden"  name="product_id" value="{{ $product->id }}">

                        <input type="hidden"  name="quantity" value="1">

                        <button  type="submit" class="product_btn_link">
                        {{dynamic_lang('order_now')}}
                        </button>
                    </form>
                </div>
            </div>
            @else
            <div class="product_btn_group">
                <div class="product_btn">
                    <a @if ($hasVariants) data-bs-toggle="modal" data-bs-target="#order_cart_modal{{ $product->id }}" href="" 
                        @else
                    href="{{ route('single.product', $product->slug) }}" @endif class="product_btn_link">
                        {{dynamic_lang('order_now')}}
                    </a>
                </div>
            </div>
            @endif
        @endif
         --}}

        
       {{-- @if ($product->stock <= 0 && $site_configurations->show_stock_out == 1)
            <div class="product_btn">
                <a class="button_disable_add_to_cart">
                    <i class="fa-solid fa-cart-shopping"></i>
                    {{dynamic_lang('stock_out')}}
                </a>
            </div>
        @else
            <div class="product_btn_group">
                <div class="product_btn">
                    <a href="{{ route('single.product', $product->slug) }}" class="product_btn_link">
                        {{dynamic_lang('order_now')}}
                    </a>
                </div>
            </div>
        @endif  --}}
    </div>
</div>


<!-- Modal Template 2 Section add_to_cart -->
@include('frontend.components.add_to_cart_modal')
@include('frontend.components.order_now_modal')

<!-- Modal Template 2 Section Cart 2 -->



<!--================= Popup model Add to card Start  ==============-->
