<div class="product_card">
    <div class="product_image" style="aspect-ratio:{{ $site_configurations->image_aspect_ratio }}">
        <a href="{{ route('single.product', $product->slug) }}">
            <img src="{{ asset('storage/' . $product->thumbnail_img) }}" alt="{{ $product->name }}">
        </a>

        @if ($product->discount)
            <div class="product_discount">
                <span>{{ getProductDiscountPrice($product->price, $product->sale_price) }}%</span>
            </div>
        @endif

        @if ($product->is_free_delivery == 1)
            <div class="fee_delivery">
                <span>{{dynamic_lang('free_delivery')}}</span>
            </div>
        @endif
        
    </div>
    <div class="product_content">
        <div class="product_name">
            <a href="{{ route('single.product', $product->slug) }}" class="product_name_link">{{ $product->name }}</a>
        </div>
        <div class="product_price">
            <span class="product_new_price">TK {{ $product->sale_price }}</span>
            @if ($product->price > $product->sale_price)
                <span class="product_discount_price">TK {{ $product->price }}</span>
            @endif
        </div>
    </div>
</div>


<!-- Modal Template 2 Section add_to_cart -->
@include('frontend.components.add_to_cart_modal')
@include('frontend.components.order_now_modal')
<!-- Modal Template 2 Section Cart 2 -->