@extends('frontend.app')
@section('content')


    <section class="featured_area section_padding_bottom">
        <div class="container">
            <div class="row">
                <div class="section_title text-center">
                    @if ($is_country == 1)
                        <h2>Country Wise Products</h2>
                    @else
                        <h2>Skin Concern Products</h2>
                    @endif

                </div>
            </div>
        </div>
        <div class="container section_top_space">
            <div class="row gy-5 gx-3">

                @forelse ($products as $product)
                    <div class="col-xxl-2 column-4  col-lg-3 col-md-4 col-sm-6 col-6">
                        <div class="product_card">
                            <div class="product_image">
                                <a href="{{ route('single.product', $product->slug) }}">
                                    <img src="{{ asset('storage/' . $product->thumbnail_img) }}" alt="product">
                                </a>
                                <div class="product_discount">
                                    <span>{{ getProductDiscountPrice($product->price, $product->sale_price) }}%</span>
                                </div>
                                <button class="cart_wishlist_btn" id="{{ $product->id }}" onclick="addToWishList(this.id)">
                                    <i class="fa-regular fa-heart"></i>
                                </button>

                            </div>
                            <div class="product_content">
                                @if ($product->stock <= 0 && $site_configurations->show_stock_out == 1)
                                    <div class="product_btn">
                                        <a type="button" @disabled(true) class="product_btn_link_stock_out">
                                            {{-- <i class="fa-solid fa-cart-plus"></i> --}}
                                            OUT OF STOCK
                                        </a>
                                    </div>
                                @else
                                    <div class="product_btn">
                                        <a onclick="addToCardFromHome(this.id)"type="button" id="{{ $product->id }}"
                                            class="product_btn_link">
                                            <i class="fa-solid fa-cart-plus"></i>
                                            Add To Cart
                                        </a>
                                    </div>
                                @endif
                                <div class="product_name">
                                    <a href="{{ route('single.product', $product->slug) }}" class="product_name_link">
                                        <h2>{{ $product->name }}</h2>
                                    </a>
                                </div>
                                <div class="product_rating">
                                    @if ($product->avg_review)
                                        @if ($product->avg_review >= 0 && $product->avg_review <= 5)
                                            @for ($i = 1; $i <= 5; $i++)
                                                @if ($product->avg_review >= $i)
                                                    <span><i class="fa-solid fa-star"></i></span>
                                                @elseif ($product->avg_review >= $i - 0.5)
                                                    <span><i class="fa-regular fa-star"></i></span>
                                                @else
                                                    <span> <i class="ion-ios-star-half"></i></span>
                                                @endif
                                            @endfor
                                            @if ($product->review_ratings)
                                                <span class="cart_rating_count">({{ $product->review_ratings }})
                                                    Reviews</span>
                                            @endif
                                        @endif
                                    @endif
                                </div>
                                <div class="product_price">
                                    <span class="product_new_price">{{ $product->sale_price }} TK</span>
                                    @if ($product->price > $product->sale_price)
                                        <span class="product_discount_price">{{ $product->price }} TK</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="no_product_found_img_box">
                        <img class="no_product_found_img" src="{{ asset('frontend') }}/images/nproduct_img.png"
                            alt="payment-method">
                    </div>
                @endforelse
            </div>
        </div>
    </section>

@endsection
