@php
    $url = explode('/', request()->url());
    $site_configuration = App\Models\SiteConfiguration::select('affiliate_active')->first();

@endphp
<div class="profile_left_side">
    <div class="profile_pic_content">
        <div class="profile_pic">
            @if (Auth::guard('customer')->user()->google_id != null)
                <img src="{{ Auth::guard('customer')->user()->image }}" alt="{{ Auth::guard('customer')->user()->name }}">
            @elseif (Auth::guard('customer')->user()->image != null)
                <img src="{{ asset('storage/' . Auth::guard('customer')->user()->image) }}" alt="user">
            @else
                <img src="{{ asset('frontend') }}/images/user/1.png" alt="{{ Auth::guard('customer')->user()->name }}">
            @endif
        </div>
        <div class="profile_name">
            <h5>{{ Auth::guard('customer')->user()->name }}</h5>
        </div>
    </div>
    <div class="profile_menu_list">
        <ul id="profile_area_list">
            <li @if (in_array('dashboard', $url)) class="active" @endif>
                <a href="{{ route('user.dashboard') }}" class="profile_menu_list_link">
                    <i class="fa-solid fa-table-cells-large"></i>
                    Dashboard
                </a>
            </li>

            <li @if (in_array('profile', $url)) class="active" @endif>
                <a href="{{ route('user.profile') }}" class="profile_menu_list_link">
                    <i class="fa-regular fa-user"></i>
                    Profile
                </a>
            </li>
            <li @if (in_array('profile-edit', $url)) class="active" @endif>
                <a href="{{ route('user.profile.edit') }}" class="profile_menu_list_link">
                    <i class="fa-regular fa-pen-to-square"></i>
                    Edit Profile
                </a>
            </li>
            <li @if (in_array('change-password', $url)) class="active" @endif>
                <a href="{{ route('user.change.password') }}" class="profile_menu_list_link">
                    <i class="fa-solid fa-key"></i>
                    Change Password
                </a>
            </li>
            @if ($site_configuration->affiliate_active == 1)
                <li>
                    <a href="{{ route('user.affiliate') }}" class="profile_menu_list_link">
                        <i class="fa-solid fa-square-poll-vertical"></i>
                        Affiliates
                    </a>
                </li>


                <li>
                    <a href="{{ route('user.commission.list', Auth::guard('customer')->user()->id) }}"
                        class="profile_menu_list_link">
                        <i class="fa-solid fa-square-poll-vertical"></i>

                        Affiliates Commission List
                    </a>
                </li>

                <li>
                    <a href="{{ route('user.affiliate.list', Auth::guard('customer')->user()->id) }}"
                        class="profile_menu_list_link">
                        <i class="fa-solid fa-square-poll-vertical"></i>
                        Affiliates Withdrawn List
                    </a>
                </li>
                {{-- @if (Auth::guard('customer')->user()->status == 7)
            <li>
                <a href="{{ route('user.coupon.income', Auth::guard('customer')->user()->id)  }}" class="profile_menu_list_link">
                    <i class="fa-solid fa-square-poll-vertical"></i>
                     Coupon Income
                </a>
            </li>
          
            <li>
                <a href="{{ route('user.coupon.income.list', Auth::guard('customer')->user()->id) }}"
                    class="profile_menu_list_link">
                    <i class="fa-solid fa-square-poll-vertical"></i>
                 
                    Coupon Commission List
                </a>
            </li>
            <li>
                <a href="{{ route('user.coupon.income.withdraw.list', Auth::guard('customer')->user()->id) }}"
                    class="profile_menu_list_link">
                    <i class="fa-solid fa-square-poll-vertical"></i>
                    Coupon Withdrawn List
                </a>
            </li>
            @endif --}}
            @endif
            <li>
                <a href="{{ route('user.logout') }}" class="profile_menu_list_link">
                    <i class="fa-solid fa-right-from-bracket"></i>
                    Logout
                </a>
            </li>
        </ul>
    </div>
</div>
