@extends('frontend.app')
@section('title', 'LogIn')
@section('content')
    <!--============ Auth Area Start ============-->
    <section class="auth_area section_padding">
        <div class="container">
            <div class="row">
                <div class="col-xxl-4 col-xl-5 col-lg-6 col-md-8 col-sm-10 col-12 m-auto">
                    <div class="auth_wrap">
                        <div class="auth_title">
                            <h3>Welcome Back</h3>
                        </div>
                        <form action="{{ route('login') }}" method="POST">
                            @csrf
                            <div class="auth_form">
                                <div class="auth_item">
                                    <label>Mobile No <span class="required_r">*</span></label>
                                    <input type="text" name="phone" value="{{ old('phone') }}"
                                        placeholder="01xxxxxxxxx">
                                    @error('phone')
                                        <span class="is_error">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="auth_item">
                                    <label>Password <span class="required_r">*</span></label>
                                    <input type="password" name="password" value="{{ old('password') }}"
                                        placeholder="password">
                                    @error('password')
                                        <span class="is_error">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="auth_sub_btn">
                                    <button type="submit" class="auth_sub_btn_link">Login</button>
                                </div>
                                <div class="auth_sub_btn_two">
                                    <a href="{{ route('login.otp') }}" class="auth_sub_btn_two_link">Login With OTP</a>
                                </div>

                                <div class="divider">
                                    <span>Or continue with</span>
                                </div>


                                <div class="social_auth_btn">
                                    <a href="{{ route('login.google') }}" class="auth_google_btn_link google-btn">Google
                                        <img src="https://cdn-icons-png.flaticon.com/512/300/300221.png" alt="Google Icon"
                                            width="20" height="20">
                                    </a>
                                    {{-- <a href="{{ route('login.facebook') }}" class="auth_google_btn_link">Facebook 
                                        <img src="https://cdn-icons-png.flaticon.com/512/733/733547.png" alt="Facebook Icon"
                                            width="20" height="20">
                                    </a> --}}
                                </div>
                                <div class="auth_link_page auth_reg">
                                    <p>Don't have an account?</p>
                                    <a href="{{ route('register') }}" class="auth_link_page_link">Register here</a>
                                </div>


                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============ Auth Area End ============-->
@endsection
