@extends('frontend.app')
@section('title','Register')
@section('content')
     <!--============ Auth Area Start ============-->
     <section class="auth_area section_padding">
        <div class="container">
            <div class="row">
                <div class="col-xxl-5 col-xl-5 col-lg-6 col-md-8 col-sm-10 col-12 m-auto">
                    <div class="auth_wrap">
                        <div class="auth_title">
                            <h3>Merchant Register</h3>
                        </div>
                        <form action="{{route('merchant.register.store')}}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="auth_form">
                                <div class="auth_item">
                                    <label>Name <span class="required_r">*</span></label>
                                    <input type="text" name="name" value="{{old('name')}}" placeholder="name">
                                    @error('name')
                                        <span class="is_error">{{$message}}</span>
                                    @enderror
                                </div>

                                <div class="auth_item">
                                    <label>Company Name <span class="required_r">*</span></label>
                                    <input type="text" name="company_name" value="{{old('company_name')}}" placeholder="company name">
                                    @error('company_name')
                                        <span class="is_error">{{$message}}</span>
                                    @enderror
                                </div>

                                <div class="auth_item">
                                    <label>Mobile <span class="required_r">*</span></label>
                                    <input type="text" name="phone" value="{{old('phone')}}" maxlength="11" placeholder="phone">
                                    @error('phone')
                                        <span class="is_error">{{$message}}</span>
                                    @enderror
                                </div>

                                <div class="auth_item">
                                    <label>Address  <span class="required_r">*</span></label>
                                    <input type="text" name="address" value="{{old('address')}}" placeholder="address">
                                    @error('address')
                                        <span class="is_error">{{$message}}</span>
                                    @enderror
                                </div>


                                <div class="auth_item">
                                    <label>NID/BIRTH CERTIFICATE <span class="required_r">*</span></label>
                                    <input type="text" name="nid" value="{{old('nid')}}" placeholder="NID/BIRTH CERTIFICATE">
                                    @error('nid')
                                        <span class="is_error">{{$message}}</span>
                                    @enderror
                                </div>

                                <div class="auth_item">
                                    <label>Date of Birth <span class="required_r">*</span></label>
                                    <input type="date" name="dob" value="{{old('dob')}}" placeholder="Date Of Birth">
                                    @error('dob')
                                        <span class="is_error">{{$message}}</span>
                                    @enderror
                                </div>


                                <div class="auth_item">
                                    <label>Password <span class="required_r">*</span></label>
                                    <input type="password" name="password" placeholder="password">
                                    @error('password')
                                        <span class="is_error">{{$message}}</span>
                                    @enderror
                                </div>

                                <div class="auth_item">
                                    <label>Confrim Password <span class="required_r">*</span></label>
                                    <input type="confirm_password" name="confirm_password" placeholder="confirm password">
                                    @error('confirm_password')
                                        <span class="is_error">{{$message}}</span>
                                    @enderror
                                </div>


                                <div class="auth_item">
                                    <label>Company Image</label>
                                    <input type="file" name="image">
                                    @error('image')
                                        <span class="is_error">{{$message}}</span>
                                    @enderror
                                </div>


                                <div class="auth_item">
                                    <label>NID Image</label>
                                    <input type="file" name="nid_image">
                                    @error('nid_image')
                                        <span class="is_error">{{$message}}</span>
                                    @enderror
                                </div>

                                <div class="auth_sub_btn">
                                    <button type="submit" class="auth_sub_btn_link">Register</button>
                                </div>
                                <div class="auth_link_page">
                                    <p>Already have an account?</p>
                                    <a href="/merchant/login" class="auth_link_page_link">Login</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============ Auth Area End ============-->
@endsection